/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.testsuite.pages.AbstractAccountPage;
import org.keycloak.testsuite.util.DroneUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AccountUpdateProfilePage
extends AbstractAccountPage {
    @FindBy(id="username")
    private WebElement usernameInput;
    @FindBy(id="firstName")
    private WebElement firstNameInput;
    @FindBy(id="lastName")
    private WebElement lastNameInput;
    @FindBy(id="email")
    private WebElement emailInput;
    @FindBy(id="referrer")
    private WebElement backToApplicationLink;
    @FindBy(css="button[type=\"submit\"][value=\"Save\"]")
    private WebElement submitButton;
    @FindBy(css="button[type=\"submit\"][value=\"Cancel\"]")
    private WebElement cancelButton;
    @FindBy(className="alert-success")
    private WebElement successMessage;
    @FindBy(className="alert-error")
    private WebElement errorMessage;

    public String getPath() {
        return RealmsResource.accountUrl((UriBuilder)UriBuilder.fromUri((URI)this.getAuthServerRoot())).build(new Object[]{"test"}).toString();
    }

    public String getPath(String realm) {
        return RealmsResource.accountUrl((UriBuilder)UriBuilder.fromUri((URI)this.getAuthServerRoot())).build(new Object[]{realm}).toString();
    }

    public void updateProfile(String firstName, String lastName, String email) {
        this.firstNameInput.clear();
        this.firstNameInput.sendKeys(new CharSequence[]{firstName});
        this.lastNameInput.clear();
        this.lastNameInput.sendKeys(new CharSequence[]{lastName});
        this.emailInput.clear();
        this.emailInput.sendKeys(new CharSequence[]{email});
        this.submitButton.click();
    }

    public void updateProfile(String username, String firstName, String lastName, String email) {
        this.usernameInput.clear();
        this.usernameInput.sendKeys(new CharSequence[]{username});
        this.firstNameInput.clear();
        this.firstNameInput.sendKeys(new CharSequence[]{firstName});
        this.lastNameInput.clear();
        this.lastNameInput.sendKeys(new CharSequence[]{lastName});
        this.emailInput.clear();
        this.emailInput.sendKeys(new CharSequence[]{email});
        this.submitButton.click();
    }

    public void updateUsername(String username) {
        this.usernameInput.clear();
        this.usernameInput.sendKeys(new CharSequence[]{username});
        this.submitButton.click();
    }

    public void updateEmail(String email) {
        this.emailInput.clear();
        this.emailInput.sendKeys(new CharSequence[]{email});
        this.submitButton.click();
    }

    public void updateAttribute(String attrName, String attrValue) {
        WebElement attrElement = this.findAttributeInputElement(attrName);
        attrElement.clear();
        attrElement.sendKeys(new CharSequence[]{attrValue});
        this.submitButton.click();
    }

    public void clickCancel() {
        this.cancelButton.click();
    }

    public String getUsername() {
        return this.usernameInput.getAttribute("value");
    }

    public String getFirstName() {
        return this.firstNameInput.getAttribute("value");
    }

    public String getLastName() {
        return this.lastNameInput.getAttribute("value");
    }

    public String getEmail() {
        return this.emailInput.getAttribute("value");
    }

    public String getAttribute(String attrName) {
        WebElement attrElement = this.findAttributeInputElement(attrName);
        return attrElement.getAttribute("value");
    }

    @Override
    public boolean isCurrent() {
        WebDriver currentDriver = DroneUtils.getCurrentDriver();
        return currentDriver.getTitle().contains("Account Management") && currentDriver.getPageSource().contains("Edit Account");
    }

    @Override
    public void open() {
        this.driver.navigate().to(this.getPath());
    }

    public void open(String realm) {
        this.driver.navigate().to(this.getPath(realm));
    }

    public void backToApplication() {
        this.backToApplicationLink.click();
    }

    public String getBackToApplicationLinkText() {
        try {
            return this.backToApplicationLink.getText();
        }
        catch (NoSuchElementException ignored) {
            return null;
        }
    }

    public String getBackToApplicationLinkHref() {
        try {
            return this.backToApplicationLink.getAttribute("href");
        }
        catch (NoSuchElementException ignored) {
            return null;
        }
    }

    public String getSuccess() {
        return this.successMessage.getText();
    }

    public String getError() {
        return this.errorMessage.getText();
    }

    public boolean isPasswordUpdateSupported() {
        return this.driver.getPageSource().contains(this.getPath() + "/password");
    }

    private WebElement findAttributeInputElement(String attrName) {
        String attrId = "user.attributes." + attrName;
        return this.driver.findElement(By.id((String)attrId));
    }
}

