/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.services.resources.account.AccountFormService;
import org.keycloak.testsuite.pages.AbstractAccountPage;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AccountTotpPage
extends AbstractAccountPage {
    @FindBy(id="totpSecret")
    private WebElement totpSecret;
    @FindBy(id="totp")
    private WebElement totpInput;
    @FindBy(id="userLabel")
    private WebElement totpLabelInput;
    @FindBy(css="button[type=\"submit\"]")
    private WebElement submitButton;
    @FindBy(id="remove-mobile")
    private WebElement removeLink;
    @FindBy(id="mode-barcode")
    private WebElement barcodeLink;
    @FindBy(id="mode-manual")
    private WebElement manualLink;

    private String getPath() {
        return AccountFormService.totpUrl((UriBuilder)UriBuilder.fromUri((URI)this.getAuthServerRoot())).build(new Object[]{"test"}).toString();
    }

    public void configure(String totp) {
        this.totpInput.sendKeys(new CharSequence[]{totp});
        this.submitButton.click();
    }

    public void configure(String totp, String userLabel) {
        this.totpInput.sendKeys(new CharSequence[]{totp});
        this.totpLabelInput.sendKeys(new CharSequence[]{userLabel});
        this.submitButton.click();
    }

    public String getTotpSecret() {
        return this.totpSecret.getAttribute("value");
    }

    @Override
    public boolean isCurrent() {
        return this.driver.getTitle().contains("Account Management") && this.driver.getCurrentUrl().split("\\?")[0].endsWith("/account/totp");
    }

    @Override
    public void open() {
        this.driver.navigate().to(this.getPath());
    }

    public void removeTotp() {
        this.removeLink.click();
    }

    public void clickManual() {
        this.manualLink.click();
    }

    public void clickBarcode() {
        this.barcodeLink.click();
    }
}

