/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.services.Urls;
import org.keycloak.testsuite.pages.AbstractAccountPage;
import org.keycloak.testsuite.util.UIUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class AccountApplicationsPage
extends AbstractAccountPage {
    @Override
    public boolean isCurrent() {
        return this.driver.getTitle().contains("Account Management") && this.driver.getCurrentUrl().endsWith("/account/applications");
    }

    @Override
    public void open() {
        this.driver.navigate().to(this.getPath());
        WaitUtils.waitForPageToLoad();
    }

    private String getPath() {
        return Urls.accountApplicationsPage((URI)this.getAuthServerRoot(), (String)"test").toString();
    }

    public void revokeGrant(String clientId) {
        UIUtils.clickLink(this.driver.findElement(By.id((String)("revoke-" + clientId))));
    }

    public Map<String, AppEntry> getApplications() {
        HashMap<String, AppEntry> table = new HashMap<String, AppEntry>();
        for (WebElement r : this.driver.findElements(By.tagName((String)"tr"))) {
            int count = 0;
            AppEntry currentEntry = null;
            block9: for (WebElement col : r.findElements(By.tagName((String)"td"))) {
                switch (++count) {
                    case 1: {
                        currentEntry = new AppEntry();
                        String client = col.getText();
                        WebElement link = null;
                        try {
                            link = col.findElement(By.tagName((String)"a"));
                            String href = link.getAttribute("href");
                            currentEntry.setHref(href);
                        }
                        catch (Exception href) {
                            // empty catch block
                        }
                        table.put(client, currentEntry);
                        break;
                    }
                    case 2: {
                        String[] roles;
                        String rolesStr = col.getText();
                        for (String role : roles = rolesStr.split(",")) {
                            role = role.trim();
                            currentEntry.addAvailableRole(role);
                        }
                        continue block9;
                    }
                    case 3: {
                        String[] clientScopes;
                        String clientScopesStr = col.getText();
                        if (clientScopesStr.isEmpty()) break;
                        for (String clientScope : clientScopes = clientScopesStr.split(",")) {
                            clientScope = clientScope.trim();
                            currentEntry.addGrantedClientScope(clientScope);
                        }
                        continue block9;
                    }
                    case 4: {
                        String[] grants;
                        String additionalGrant = col.getText();
                        if (additionalGrant.isEmpty()) break;
                        for (String grant : grants = additionalGrant.split(",")) {
                            grant = grant.trim();
                            currentEntry.addAdditionalGrant(grant);
                        }
                        break;
                    }
                }
            }
        }
        table.remove("Application");
        return table;
    }

    public static class AppEntry {
        private final List<String> rolesAvailable = new ArrayList<String>();
        private final List<String> clientScopesGranted = new ArrayList<String>();
        private final List<String> additionalGrants = new ArrayList<String>();
        private String href = null;

        private void addAvailableRole(String role) {
            this.rolesAvailable.add(role);
        }

        private void addGrantedClientScope(String clientScope) {
            this.clientScopesGranted.add(clientScope);
        }

        private void addAdditionalGrant(String grant) {
            this.additionalGrants.add(grant);
        }

        public void setHref(String href) {
            this.href = href;
        }

        public String getHref() {
            return this.href;
        }

        public List<String> getRolesAvailable() {
            return this.rolesAvailable;
        }

        public List<String> getClientScopesGranted() {
            return this.clientScopesGranted;
        }

        public List<String> getAdditionalGrants() {
            return this.additionalGrants;
        }
    }
}

