/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.openqa.selenium.WebDriver;

public abstract class AbstractPage {
    @ArquillianResource
    protected SuiteContext suiteContext;
    @ArquillianResource
    protected WebDriver driver;
    @ArquillianResource
    protected OAuthClient oauth;

    public void assertCurrent() {
        String name = this.getClass().getSimpleName();
        Assert.assertTrue((String)("Expected " + name + " but was " + DroneUtils.getCurrentDriver().getTitle() + " (" + DroneUtils.getCurrentDriver().getCurrentUrl() + ")"), (boolean)this.isCurrent());
    }

    protected URI getAuthServerRoot() {
        try {
            return KeycloakUriBuilder.fromUri((URI)this.suiteContext.getAuthServerInfo().getBrowserContextRoot().toURI()).path("/auth/").build(new Object[0]);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract boolean isCurrent();

    public abstract void open() throws Exception;

    public void setDriver(WebDriver driver) {
        this.driver = driver;
        this.oauth.setDriver(driver);
    }
}

