/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.page;

import java.util.function.Function;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.UIUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class AbstractPatternFlyAlert {
    public static final String ALERT_CLASS_NAME = "alert";
    protected final Logger log = Logger.getLogger(this.getClass());
    @FindBy(className="alert")
    protected WebElement alertRoot;
    @Drone
    protected WebDriver driver;

    public boolean isDisplayed() {
        return UIUtils.isElementVisible(this.alertRoot);
    }

    public static void waitUntilDisplayed() {
        AbstractPatternFlyAlert.waitUntilDisplayedOrHidden(true);
    }

    public static void waitUntilHidden() {
        AbstractPatternFlyAlert.waitUntilDisplayedOrHidden(false);
    }

    private static void waitUntilDisplayedOrHidden(boolean displayed) {
        ExpectedCondition condition = ExpectedConditions.visibilityOfElementLocated((By)By.className((String)ALERT_CLASS_NAME));
        condition = displayed ? condition : ExpectedConditions.not((ExpectedCondition)condition);
        new WebDriverWait(DroneUtils.getCurrentDriver(), (long)(WaitUtils.PAGELOAD_TIMEOUT_MILLIS / 1000)).until((Function)condition);
    }

    public String getText() {
        return UIUtils.getTextFromElement(this.alertRoot);
    }

    public boolean isSuccess() {
        return this.checkAlertType("success");
    }

    public void assertDisplayed() {
        Assert.assertTrue((String)"Alert should displayed", (boolean)this.isDisplayed());
    }

    public void assertNotDisplayed() {
        Assert.assertFalse((String)"Alert shouldn't be displayed", (boolean)this.isDisplayed());
    }

    public void assertSuccess() {
        this.assertSuccess(null);
    }

    public void assertSuccess(String expectedText) {
        this.assertDisplayed();
        Assert.assertTrue((String)"Alert type should be success", (boolean)this.isSuccess());
        if (expectedText != null) {
            Assert.assertEquals((Object)expectedText, (Object)this.getText());
        }
    }

    protected boolean checkAlertType(String type) {
        return UIUtils.doesElementClassContain(this.alertRoot, "alert-" + type);
    }
}

