/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.console.page.fragment;

import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;

public class LocaleDropdown {
    protected Logger log = Logger.getLogger(this.getClass());
    @Root
    private WebElement root;
    @FindBy(tagName="ul")
    private WebElement dropDownMenu;
    @FindBy(id="kc-current-locale-link")
    private WebElement currentLocaleLink;
    @Drone
    private WebDriver driver;

    public String getSelected() {
        return UIUtils.getTextFromElement(this.currentLocaleLink);
    }

    public void selectByText(String text) {
        if (this.driver instanceof IOSDriver) {
            ((IOSDriver)this.driver).executeScript("arguments[0].setAttribute('style', 'display: block')", new Object[]{this.dropDownMenu});
        } else if (this.driver instanceof AndroidDriver || this.driver instanceof InternetExplorerDriver) {
            this.currentLocaleLink.click();
        } else {
            Actions actions = new Actions(this.driver);
            this.log.info((Object)"Moving mouse cursor to the localization menu");
            actions.moveToElement(this.currentLocaleLink, -10, 0).moveToElement(this.currentLocaleLink).perform();
        }
        UIUtils.clickLink(this.dropDownMenu.findElement(By.xpath((String)("./li/a[text()='" + text + "']"))));
    }

    public void selectAndAssert(String text) {
        Assert.assertNotEquals((Object)text, (Object)this.getSelected());
        this.selectByText(text);
        Assert.assertEquals((Object)text, (Object)this.getSelected());
    }
}

