/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.console.page.fragment;

import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.keycloak.testsuite.util.UIUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class DataTable {
    @Drone
    protected WebDriver driver;
    @FindBy(css="input[class*='search']")
    private WebElement searchInput;
    @FindBy(css="div[class='input-group-addon'] i")
    private WebElement searchButton;
    @FindBy(tagName="thead")
    private WebElement header;
    @FindBy(css="tbody")
    private WebElement body;
    @FindBy(xpath="tbody/tr[@class='ng-scope']")
    private List<WebElement> rows;
    @FindBy(tagName="tfoot")
    private WebElement footer;

    public void search(String pattern) {
        this.searchInput.sendKeys(new CharSequence[]{pattern});
        UIUtils.clickLink(this.searchButton);
    }

    public void clickHeaderButton(String buttonText) {
        UIUtils.clickLink(this.header.findElement(By.xpath((String)(".//button[text()='" + buttonText + "']"))));
    }

    public void clickHeaderLink(String linkText) {
        UIUtils.clickLink(this.header.findElement(By.linkText((String)linkText)));
    }

    public WebElement body() {
        return this.body;
    }

    public WebElement footer() {
        return this.footer;
    }

    public List<WebElement> rows() {
        WaitUtils.waitForPageToLoad();
        WaitUtils.pause(500L);
        return this.rows;
    }

    public WebElement getRowByLinkText(String text) {
        WebElement row = this.body.findElement(By.xpath((String)(".//tr[./td/a[text()='" + text + "']]")));
        return row;
    }

    public void clickRowByLinkText(String text) {
        UIUtils.clickLink(this.body.findElement(By.xpath((String)(".//tr/td/a[text()='" + text + "']"))));
    }

    public WebElement getActionButton(WebElement row, String buttonText) {
        return row.findElement(By.xpath((String)(".//td[contains(@class, 'kc-action-cell') and text()='" + buttonText + "']")));
    }

    public WebElement getActionButton(String rowLinkText, String buttonText) {
        return this.getActionButton(this.getRowByLinkText(rowLinkText), buttonText);
    }

    public boolean isActionButtonVisible(String rowLinkText, String buttonText) {
        try {
            return this.getActionButton(rowLinkText, buttonText).isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public void clickRowActionButton(WebElement row, String buttonText) {
        UIUtils.clickLink(this.getActionButton(row, buttonText));
    }

    public void clickRowActionButton(String rowLinkText, String buttonText) {
        UIUtils.clickLink(this.getActionButton(rowLinkText, buttonText));
    }

    public String getColumnText(WebElement row, int colIndex) {
        return UIUtils.getTextFromElement((WebElement)row.findElements(By.tagName((String)"td")).get(colIndex));
    }

    public String getColumnText(String rowLinkText, int colIndex) {
        return this.getColumnText(this.getRowByLinkText(rowLinkText), colIndex);
    }

    public boolean isRowPresent(String rowLinkText) {
        try {
            return this.getRowByLinkText(rowLinkText).isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }
}

