/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.console.page.fragment;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.fragment.Root;
import org.keycloak.testsuite.util.UIUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public abstract class AbstractMultipleSelect2<R> {
    @Root
    private WebElement root;
    @Drone
    private WebDriver driver;
    @FindBy(xpath="//input[contains(@class,'select2-focused')]")
    private WebElement search;
    @FindBy(xpath="//div[contains(@class,'select2-result-label')]")
    private List<WebElement> result;

    public void update(Set<R> values) {
        Set<R> selection = this.getSelected();
        for (R value : values) {
            if (selection.contains(value)) continue;
            this.select(value);
        }
        for (R selected : selection) {
            boolean isSelected = false;
            for (R value : values) {
                if (!selected.equals(value)) continue;
                isSelected = true;
                break;
            }
            if (isSelected) continue;
            this.deselect(selected);
        }
    }

    public void select(R value) {
        WaitUtils.pause(500L);
        this.root.click();
        WaitUtils.pause(500L);
        String id = this.identity().apply(value);
        this.search.sendKeys(new CharSequence[]{id});
        WaitUtils.waitForPageToLoad();
        if (this.result.isEmpty()) {
            this.search.sendKeys(new CharSequence[]{Keys.ESCAPE});
            return;
        }
        for (WebElement result : this.result) {
            if (!this.match(result.getText(), id)) continue;
            UIUtils.clickLink(result);
            return;
        }
    }

    protected abstract Function<R, String> identity();

    protected boolean match(String result, String search) {
        return result != null && result.equalsIgnoreCase(search);
    }

    public Set<R> getSelected() {
        HashSet<R> values = new HashSet<R>();
        for (WebElement selected : this.getSelectedElements()) {
            R value = this.representation().apply(selected);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    protected abstract List<WebElement> getSelectedElements();

    protected abstract Function<WebElement, R> representation();

    public void deselect(R value) {
        this.onDeselect(value);
    }

    protected void onDeselect(R value) {
        for (WebElement selected : this.getSelectedElements()) {
            if (!this.deselect().apply(selected, value).booleanValue()) continue;
            return;
        }
    }

    protected BiFunction<WebElement, R, Boolean> deselect() {
        return (selected, value) -> {
            WebElement selection = (WebElement)selected.findElements(By.tagName((String)"div")).get(0);
            if (this.identity().apply(value).equals(selection.getText())) {
                WebElement element = selected.findElement(By.xpath((String)".//a[contains(@class,'select2-search-choice-close')]"));
                JavascriptExecutor executor = (JavascriptExecutor)this.driver;
                executor.executeScript("arguments[0].click();", new Object[]{element});
                WaitUtils.pause(500L);
                return true;
            }
            return false;
        };
    }

    protected WebElement getRoot() {
        return this.root;
    }

    protected WebDriver getDriver() {
        return this.driver;
    }
}

