/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client.resources;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.ClientNotificationEndpointRequest;
import org.keycloak.testsuite.rest.representation.TestAuthenticationChannelRequest;

public interface TestOIDCEndpointsApplicationResource {
    @GET
    @Produces(value={"application/json"})
    @Path(value="/generate-keys")
    public Map<String, String> generateKeys(@QueryParam(value="jwaAlgorithm") String var1);

    @GET
    @Produces(value={"application/json"})
    @Path(value="/generate-keys")
    public Map<String, String> generateKeys(@QueryParam(value="jwaAlgorithm") String var1, @QueryParam(value="advertiseJWKAlgorithm") Boolean var2);

    @GET
    @Produces(value={"application/json"})
    @Path(value="/get-keys-as-pem")
    public Map<String, String> getKeysAsPem();

    @GET
    @Produces(value={"application/json"})
    @Path(value="/get-keys-as-base64")
    public Map<String, String> getKeysAsBase64();

    @GET
    @Produces(value={"application/json"})
    @Path(value="/get-jwks")
    public JSONWebKeySet getJwks();

    @GET
    @Path(value="/set-oidc-request")
    @Produces(value={"application/jwt"})
    public void setOIDCRequest(@QueryParam(value="realmName") String var1, @QueryParam(value="clientId") String var2, @QueryParam(value="redirectUri") String var3, @QueryParam(value="maxAge") String var4, @QueryParam(value="state") String var5, @QueryParam(value="jwaAlgorithm") String var6);

    @GET
    @Path(value="/set-oidc-request")
    @Produces(value={"application/jwt"})
    public void setOIDCRequest(@QueryParam(value="realmName") String var1, @QueryParam(value="clientId") String var2, @QueryParam(value="redirectUri") String var3, @QueryParam(value="maxAge") String var4, @QueryParam(value="jwaAlgorithm") String var5);

    @GET
    @Path(value="/register-oidc-request")
    @Produces(value={"application/jwt"})
    public void registerOIDCRequest(@QueryParam(value="requestObject") String var1, @QueryParam(value="jwaAlgorithm") String var2);

    @GET
    @Path(value="/register-oidc-request-symmetric-sig")
    @Produces(value={"application/jwt"})
    public void registerOIDCRequestSymmetricSig(@QueryParam(value="requestObject") String var1, @QueryParam(value="jwaAlgorithm") String var2, @QueryParam(value="clientSecret") String var3);

    @GET
    @Path(value="/get-oidc-request")
    @Produces(value={"application/jwt"})
    public String getOIDCRequest();

    @GET
    @Path(value="/set-sector-identifier-redirect-uris")
    @Produces(value={"application/json"})
    public void setSectorIdentifierRedirectUris(@QueryParam(value="redirectUris") List<String> var1);

    @GET
    @Path(value="/get-sector-identifier-redirect-uris")
    @Produces(value={"application/json"})
    public List<String> getSectorIdentifierRedirectUris();

    @POST
    @Path(value="/request-authentication-channel")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @NoCache
    public Response requestAuthenticationChannel(MultivaluedMap<String, String> var1);

    @GET
    @Path(value="/get-authentication-channel")
    @Produces(value={"application/json"})
    public TestAuthenticationChannelRequest getAuthenticationChannel(@QueryParam(value="bindingMessage") String var1);

    @POST
    @Path(value="/push-ciba-client-notification")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoCache
    public void cibaClientNotificationEndpoint(ClientNotificationEndpointRequest var1);

    @GET
    @Path(value="/get-pushed-ciba-client-notification")
    @Produces(value={"application/json"})
    @NoCache
    public ClientNotificationEndpointRequest getPushedCibaClientNotification(@QueryParam(value="clientNotificationToken") String var1);
}

