/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.junit.Assert;
import org.keycloak.common.Profile;
import org.keycloak.testsuite.client.resources.TestApplicationResource;
import org.keycloak.testsuite.client.resources.TestExampleCompanyResource;
import org.keycloak.testsuite.client.resources.TestSamlApplicationResource;
import org.keycloak.testsuite.client.resources.TestingResource;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.runonserver.FetchOnServerWrapper;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.runonserver.RunOnServerException;
import org.keycloak.testsuite.runonserver.SerializationUtil;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.util.JsonSerialization;

public class KeycloakTestingClient
implements AutoCloseable {
    private final ResteasyWebTarget target;
    private final ResteasyClient client;

    KeycloakTestingClient(String serverUrl, ResteasyClient resteasyClient) {
        if (resteasyClient != null) {
            this.client = resteasyClient;
        } else {
            ResteasyClientBuilder resteasyClientBuilder = new ResteasyClientBuilder();
            resteasyClientBuilder.connectionPoolSize(10);
            if (serverUrl.startsWith("https")) {
                resteasyClientBuilder.disableTrustManager().hostnameVerification(ResteasyClientBuilder.HostnameVerificationPolicy.ANY);
            }
            resteasyClientBuilder.httpEngine(AdminClientUtil.getCustomClientHttpEngine(resteasyClientBuilder, 10, null));
            this.client = resteasyClientBuilder.build();
        }
        this.target = this.client.target(serverUrl);
    }

    public static KeycloakTestingClient getInstance(String serverUrl) {
        return new KeycloakTestingClient(serverUrl, null);
    }

    public static KeycloakTestingClient getInstance(String serverUrl, ResteasyClient resteasyClient) {
        return new KeycloakTestingClient(serverUrl, resteasyClient);
    }

    public TestingResource testing() {
        return (TestingResource)this.target.path("/realms/master").proxy(TestingResource.class);
    }

    public TestingResource testing(String realm) {
        return (TestingResource)this.target.path("/realms/" + realm).proxy(TestingResource.class);
    }

    public void enableFeature(Profile.Feature feature) {
        try (Response response = this.testing().enableFeature(feature.toString());){
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
    }

    public void disableFeature(Profile.Feature feature) {
        try (Response response = this.testing().disableFeature(feature.toString());){
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
    }

    public TestApplicationResource testApp() {
        return (TestApplicationResource)this.target.proxy(TestApplicationResource.class);
    }

    public TestSamlApplicationResource testSamlApp() {
        return (TestSamlApplicationResource)this.target.proxy(TestSamlApplicationResource.class);
    }

    public TestExampleCompanyResource testExampleCompany() {
        return (TestExampleCompanyResource)this.target.proxy(TestExampleCompanyResource.class);
    }

    public Server server() {
        return new Server("master");
    }

    public Server server(String realm) {
        return new Server(realm);
    }

    @Override
    public void close() {
        this.client.close();
    }

    public class Server {
        private final String realm;

        public Server(String realm) {
            this.realm = realm;
        }

        public <T> T fetch(FetchOnServerWrapper<T> wrapper) throws RunOnServerException {
            return this.fetch(wrapper.getRunOnServer(), wrapper.getResultClass());
        }

        public <T> T fetch(FetchOnServer function, Class<T> clazz) throws RunOnServerException {
            try {
                String s = this.fetchString(function);
                return (T)(s == null ? null : JsonSerialization.readValue((String)s, clazz));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String fetchString(FetchOnServer function) throws RunOnServerException {
            String encoded = SerializationUtil.encode((Object)function);
            String result = KeycloakTestingClient.this.testing(this.realm != null ? this.realm : "master").runOnServer(encoded);
            if (result != null && !result.isEmpty() && result.trim().startsWith("EXCEPTION:")) {
                Throwable t = SerializationUtil.decodeException((String)result);
                if (t instanceof AssertionError) {
                    throw (AssertionError)((Object)t);
                }
                throw new RunOnServerException(t);
            }
            return result;
        }

        public void run(RunOnServer function) throws RunOnServerException {
            String encoded = SerializationUtil.encode((Object)function);
            String result = KeycloakTestingClient.this.testing(this.realm != null ? this.realm : "master").runOnServer(encoded);
            if (result != null && !result.isEmpty() && result.trim().startsWith("EXCEPTION:")) {
                Throwable t = SerializationUtil.decodeException((String)result);
                if (t instanceof AssertionError) {
                    throw (AssertionError)((Object)t);
                }
                throw new RunOnServerException(t);
            }
        }

        public void runModelTest(String testClassName, String testMethodName) throws RunOnServerException {
            String result = KeycloakTestingClient.this.testing(this.realm != null ? this.realm : "master").runModelTestOnServer(testClassName, testMethodName);
            if (result != null && !result.isEmpty() && result.trim().startsWith("EXCEPTION:")) {
                Throwable t = SerializationUtil.decodeException((String)result);
                if (t instanceof AssertionError) {
                    throw (AssertionError)((Object)t);
                }
                throw new RunOnServerException(t);
            }
        }
    }
}

