/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.LinkedList;

class InteractiveInputStream
extends InputStream {
    private LinkedList<Byte> queue = new LinkedList();
    private Thread consumer;
    private boolean closed;

    InteractiveInputStream() {
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        Byte current = null;
        int rc = 0;
        try {
            this.consumer = Thread.currentThread();
            do {
                if ((current = this.queue.poll()) == null) {
                    if (rc > 0) {
                        int n = rc;
                        return n;
                    }
                    do {
                        if (this.closed) {
                            int n = -1;
                            return n;
                        }
                        this.wait();
                    } while ((current = this.queue.poll()) == null);
                }
                b[off + rc] = current;
            } while (++rc < len);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Signalled to exit");
        }
        finally {
            this.consumer = null;
        }
        return rc;
    }

    @Override
    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        return super.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    @Override
    public synchronized int read() throws IOException {
        Byte current;
        try {
            this.consumer = Thread.currentThread();
            while ((current = this.queue.poll()) == null) {
                if (this.closed) {
                    int n = -1;
                    return n;
                }
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Signalled to exit");
        }
        finally {
            this.consumer = null;
        }
        return current.byteValue();
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        if (this.consumer != null) {
            this.consumer.interrupt();
        }
    }

    public synchronized void pushBytes(byte[] buff) {
        for (byte b : buff) {
            this.queue.add(b);
        }
        this.notify();
    }
}

