/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli.exec;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.keycloak.client.admin.cli.util.OsUtil;
import org.keycloak.testsuite.cli.OsArch;
import org.keycloak.testsuite.cli.OsUtils;
import org.keycloak.testsuite.cli.exec.InteractiveInputStream;
import org.keycloak.testsuite.cli.exec.LoggingOutputStream;
import org.keycloak.testsuite.cli.exec.StreamReaderThread;

public abstract class AbstractExec {
    public static final String WORK_DIR = System.getProperty("user.dir");
    public static final OsArch OS_ARCH = OsUtils.determineOSAndArch();
    private long waitTimeout = 30000L;
    private Process process;
    private int exitCode = -1;
    private boolean logStreams = Boolean.valueOf(System.getProperty("cli.log.output", "true"));
    protected boolean dumpStreams = true;
    protected String workDir = WORK_DIR;
    private String env;
    private String argsLine;
    private ByteArrayOutputStream stdout = new ByteArrayOutputStream();
    private ByteArrayOutputStream stderr = new ByteArrayOutputStream();
    private InputStream stdin = new InteractiveInputStream();
    private Throwable err;
    private Thread stdoutRunner;
    private Thread stderrRunner;

    public AbstractExec(String workDir, String argsLine, InputStream stdin) {
        this(workDir, argsLine, null, stdin);
    }

    public AbstractExec(String workDir, String argsLine, String env, InputStream stdin) {
        if (workDir != null) {
            this.workDir = workDir;
        }
        this.argsLine = argsLine;
        this.env = env;
        if (stdin != null) {
            this.stdin = stdin;
        }
    }

    public abstract String getCmd();

    public void execute() {
        this.executeAsync();
        if (this.err == null) {
            this.waitCompletion();
        }
    }

    public void executeAsync() {
        try {
            if (OS_ARCH.isWindows()) {
                String cmd = (this.env != null ? "set " + this.env + " & " : "") + this.fixPath(this.getCmd()) + " " + this.fixQuotes(this.argsLine);
                System.out.println("Executing: cmd.exe /c " + cmd);
                this.process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", cmd}, null, new File(this.workDir));
            } else {
                String cmd = (this.env != null ? this.env + " " : "") + this.getCmd() + " " + this.argsLine;
                System.out.println("Executing: sh -c " + cmd);
                this.process = Runtime.getRuntime().exec(new String[]{"sh", "-c", cmd}, null, new File(this.workDir));
            }
            this.stdoutRunner = new StreamReaderThread(this.process.getInputStream(), this.logStreams ? new LoggingOutputStream("STDOUT", this.stdout) : this.stdout);
            this.stdoutRunner.start();
            this.stderrRunner = new StreamReaderThread(this.process.getErrorStream(), this.logStreams ? new LoggingOutputStream("STDERR", this.stderr) : this.stderr);
            this.stderrRunner.start();
            new StreamReaderThread(this.stdin, this.process.getOutputStream()).start();
        }
        catch (Throwable t) {
            this.err = t;
        }
    }

    private String fixPath(String cmd) {
        return cmd.replaceAll("/", "\\\\");
    }

    private String fixQuotes(String argsLine) {
        argsLine = argsLine + " ";
        argsLine = argsLine.replaceAll("\"", "\\\\\"");
        argsLine = argsLine.replaceAll(" '", " \"");
        argsLine = argsLine.replaceAll("' ", "\" ");
        return argsLine;
    }

    public void waitCompletion() {
        block17: {
            if (this.stdin instanceof InteractiveInputStream) {
                ((InteractiveInputStream)this.stdin).close();
            }
            try {
                if (this.process.waitFor(this.waitTimeout, TimeUnit.MILLISECONDS)) {
                    this.exitCode = this.process.exitValue();
                    if (this.exitCode != 0) {
                        this.dumpStreams = true;
                    }
                    this.stdoutRunner.join(5000L);
                    this.stderrRunner.join(5000L);
                    break block17;
                }
                if (this.process.isAlive()) {
                    this.process.destroyForcibly();
                }
                throw new RuntimeException("Timeout after " + this.waitTimeout / 1000L + " seconds.");
            }
            catch (InterruptedException e) {
                this.dumpStreams = true;
                throw new RuntimeException("Interrupted ...", e);
            }
            catch (Throwable t) {
                this.dumpStreams = true;
                this.err = t;
            }
            finally {
                if (!this.logStreams && this.dumpStreams) {
                    try {
                        System.out.println("STDOUT: ");
                        AbstractExec.copyStream(new ByteArrayInputStream(this.stdout.toByteArray()), System.out);
                        System.out.println("STDERR: ");
                        AbstractExec.copyStream(new ByteArrayInputStream(this.stderr.toByteArray()), System.out);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public int exitCode() {
        return this.exitCode;
    }

    public Throwable error() {
        return this.err;
    }

    public InputStream stdout() {
        return new ByteArrayInputStream(this.stdout.toByteArray());
    }

    public List<String> stdoutLines() {
        return AbstractExec.parseStreamAsLines(new ByteArrayInputStream(this.stdout.toByteArray()));
    }

    public String stdoutString() {
        return new String(this.stdout.toByteArray());
    }

    public InputStream stderr() {
        return new ByteArrayInputStream(this.stderr.toByteArray());
    }

    public List<String> stderrLines() {
        return AbstractExec.filterAgentsOutput(AbstractExec.parseStreamAsLines(new ByteArrayInputStream(this.stderr.toByteArray())));
    }

    public static List<String> filterAgentsOutput(List<String> lines) {
        return lines.stream().filter(line -> !line.contains("JAVA_TOOL_OPTIONS")).collect(Collectors.toList());
    }

    public String stderrString() {
        return new String(this.stderr.toByteArray());
    }

    static List<String> parseStreamAsLines(InputStream stream) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected I/O error", e);
        }
    }

    public void waitForStdout(String content) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.waitTimeout) {
            if (this.stdoutString().indexOf(content) != -1) {
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted ...", e);
            }
        }
        throw new RuntimeException("Timed while waiting for content to appear in stdout");
    }

    public void waitForStderr(String content) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.waitTimeout) {
            if (this.stderrString().indexOf(content) != -1) {
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted ...", e);
            }
        }
        throw new RuntimeException("Timed while waiting for content to appear in stderr");
    }

    public void sendToStdin(String s) {
        if (!(this.stdin instanceof InteractiveInputStream)) {
            throw new RuntimeException("Can't push to stdin - not interactive");
        }
        ((InteractiveInputStream)this.stdin).pushBytes(s.getBytes());
    }

    public void sendLine(String s) {
        this.sendToStdin(s + OsUtil.EOL);
    }

    static void copyStream(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[8192];
        try (InputStream iss = is;){
            int c;
            while ((c = iss.read(buf)) != -1) {
                os.write(buf, 0, c);
                os.flush();
            }
        }
    }
}

