/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli;

import org.keycloak.testsuite.cli.OsArch;

public class OsUtils {
    public static OsArch determineOSAndArch() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch");
        if (arch.equals("amd64")) {
            arch = "x86_64";
        }
        if (os.startsWith("linux")) {
            if (arch.equals("x86") || arch.equals("i386") || arch.equals("i586")) {
                arch = "i686";
            }
            return new OsArch("linux", arch);
        }
        if (os.startsWith("windows")) {
            if (arch.equals("x86")) {
                arch = "i386";
            }
            if (os.indexOf("2008") != -1 || os.indexOf("2003") != -1 || os.indexOf("vista") != -1) {
                return new OsArch("win32", arch, true);
            }
            return new OsArch("win32", arch);
        }
        if (os.startsWith("sunos")) {
            return new OsArch("sunos5", "x86_64");
        }
        if (os.startsWith("mac os x")) {
            return new OsArch("osx", "x86_64");
        }
        if (os.startsWith("freebsd")) {
            return new OsArch("freebsd", arch);
        }
        throw new RuntimeException("Could not determine OS and architecture for this operating system: " + os);
    }
}

