/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page.login;

import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.graphene.page.Page;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.auth.page.AccountFields;
import org.keycloak.testsuite.auth.page.PasswordFields;
import org.keycloak.testsuite.auth.page.login.LoginActions;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class Registration
extends LoginActions {
    @Page
    private AccountFields accountFields;
    @Page
    private PasswordFields passwordFields;
    @FindBy(xpath="//a[contains(., 'Back to Login')]")
    private WebElement backToLoginLink;

    @Override
    public UriBuilder createUriBuilder() {
        return super.createUriBuilder().path("registration");
    }

    public void register(UserRepresentation user) {
        this.setValues(user);
        this.submit();
    }

    public void setValues(UserRepresentation user) {
        this.setValues(user, Users.getPasswordOf(user));
    }

    public void setValues(UserRepresentation user, String confirmPassword) {
        this.accountFields.setValues(user);
        this.passwordFields.setPassword(Users.getPasswordOf(user));
        this.passwordFields.setConfirmPassword(confirmPassword);
    }

    public boolean isUsernamePresent() {
        return this.accountFields.isUsernamePresent();
    }

    public boolean isConfirmPasswordPresent() {
        return this.passwordFields.isConfirmPasswordPresent();
    }

    public AccountFields accountFields() {
        return this.accountFields;
    }

    public PasswordFields passwordFields() {
        return this.passwordFields;
    }

    public void backToLogin() {
        UIUtils.clickLink(this.backToLoginLink);
    }
}

