/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page.login;

import org.jboss.arquillian.graphene.page.Page;
import org.keycloak.models.UserModel;
import org.keycloak.testsuite.auth.page.login.LoginForm;
import org.keycloak.testsuite.auth.page.login.RequiredActions;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class OTPSetup
extends RequiredActions {
    @Page
    private LoginForm.TotpSetupForm form;
    @FindBy(id="kc-totp-secret-qr-code")
    private WebElement barcodeImg;
    @FindBy(id="kc-totp-secret-key")
    private WebElement secretKey;
    @FindBy(id="mode-manual")
    private WebElement manualModeLink;
    @FindBy(id="mode-barcode")
    private WebElement barcodeModeLink;
    @FindBy(id="kc-totp-type")
    private WebElement otpType;
    @FindBy(id="kc-totp-algorithm")
    private WebElement otpAlgorithm;
    @FindBy(id="kc-totp-digits")
    private WebElement otpDigits;
    @FindBy(id="kc-totp-period")
    private WebElement otpPeriod;
    @FindBy(id="kc-totp-counter")
    private WebElement otpCounter;

    public void setTotp(String value) {
        this.form.setTotp(value);
    }

    public boolean isBarcodePresent() {
        try {
            return this.barcodeImg.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public String getSecretKey() {
        return this.secretKey.getText().replace(" ", "");
    }

    public boolean isSecretKeyPresent() {
        try {
            return this.secretKey.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public void clickManualMode() {
        UIUtils.clickLink(this.manualModeLink);
    }

    public void clickBarcodeMode() {
        UIUtils.clickLink(this.barcodeModeLink);
    }

    public String getOtpType() {
        return this.otpType.getText();
    }

    public String getOtpAlgorithm() {
        return this.otpAlgorithm.getText();
    }

    public String getOtpDigits() {
        return this.otpDigits.getText();
    }

    public String getOtpPeriod() {
        return this.otpPeriod.getText();
    }

    public String getOtpCounter() {
        return this.otpCounter.getText();
    }

    public void setUserLabel(String value) {
        this.form.setUserLabel(value);
    }

    @Override
    public String getActionId() {
        return UserModel.RequiredAction.CONFIGURE_TOTP.name();
    }
}

