/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page.login;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class FeedbackMessage {
    private final String SUCCESS = "success";
    private final String WARNING = "warning";
    private final String ERROR = "error";
    private final String INFO = "info";
    @FindBy(css="div[class^='alert']")
    private WebElement alertRoot;
    @FindBy(css="span[id^='input-error']")
    private WebElement inputErrorRoot;

    public boolean isPresent() {
        try {
            return this.alertRoot.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return this.getInputError() != null && !this.getInputError().isEmpty();
        }
    }

    public String getInputError() {
        try {
            return UIUtils.getTextFromElement(this.inputErrorRoot);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getText() {
        try {
            return UIUtils.getTextFromElement(this.alertRoot.findElement(By.className((String)"kc-feedback-text")));
        }
        catch (NoSuchElementException e) {
            return this.getInputError();
        }
    }

    public String getType() {
        try {
            String cssClass = this.alertRoot.getAttribute("class");
            Matcher classMatcher = Pattern.compile("alert-(.+)").matcher(cssClass);
            if (!classMatcher.find()) {
                throw new RuntimeException("Failed to identify feedback message type");
            }
            return classMatcher.group(1);
        }
        catch (NoSuchElementException e) {
            return this.getInputError() != null ? "error" : null;
        }
    }

    public boolean isSuccess() {
        return this.getType().contains("success");
    }

    public boolean isWarning() {
        return this.getType().contains("warning");
    }

    public boolean isError() {
        return this.getType().contains("error");
    }

    public boolean isInfo() {
        return this.getType().contains("info");
    }
}

