/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page;

import org.jboss.arquillian.graphene.page.Page;
import org.keycloak.testsuite.auth.page.FieldsBase;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class PasswordFields
extends FieldsBase {
    @Page
    private PasswordErrors inputErrors;
    @FindBy(id="password")
    private WebElement passwordInput;
    @FindBy(xpath="//label[@for='password']")
    private WebElement passwordLabel;
    @FindBy(id="password-new")
    private WebElement newPasswordInput;
    @FindBy(xpath="//label[@for='password-new']")
    private WebElement newPasswordLabel;
    @FindBy(id="password-confirm")
    private WebElement confirmPasswordInput;
    @FindBy(xpath="//label[@for='password-confirm']")
    private WebElement confirmPasswordLabel;

    public void setPassword(String password) {
        UIUtils.setTextInputValue(this.passwordInput, password);
    }

    public void setNewPassword(String newPassword) {
        UIUtils.setTextInputValue(this.newPasswordInput, newPassword);
    }

    public void setConfirmPassword(String confirmPassword) {
        UIUtils.setTextInputValue(this.confirmPasswordInput, confirmPassword);
    }

    public void setPasswords(String password, String newPassword, String confirmPassword) {
        this.setPassword(password);
        this.setNewPassword(newPassword);
        this.setConfirmPassword(confirmPassword);
    }

    public boolean isConfirmPasswordPresent() {
        try {
            return this.confirmPasswordInput.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public String getPasswordLabel() {
        return UIUtils.getTextFromElement(this.passwordLabel);
    }

    public String getNewPasswordLabel() {
        return UIUtils.getTextFromElement(this.newPasswordLabel);
    }

    public String getConfirmPasswordLabel() {
        return UIUtils.getTextFromElement(this.confirmPasswordLabel);
    }

    public boolean hasPasswordError() {
        return this.inputErrors.getPasswordError() != null;
    }

    public boolean hasNewPasswordError() {
        return this.hasFieldError(this.newPasswordInput);
    }

    public boolean hasConfirmPasswordError() {
        return this.inputErrors.getPasswordConfirmError() != null;
    }

    public PasswordErrors getInputErrors() {
        return this.inputErrors;
    }

    public static class PasswordErrors {
        @FindBy(id="input-error-password")
        private WebElement passwordError;
        @FindBy(id="input-error-password-confirm")
        private WebElement passwordConfirmError;

        public String getPasswordError() {
            try {
                return UIUtils.getTextFromElement(this.passwordError);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }

        public String getPasswordConfirmError() {
            try {
                return UIUtils.getTextFromElement(this.passwordConfirmError);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
    }
}

