/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.provider;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.impl.enricher.resource.URLResourceProvider;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.arquillian.annotation.AppServerBrowserContext;
import org.keycloak.testsuite.arquillian.annotation.AppServerContext;
import org.keycloak.testsuite.arquillian.annotation.AuthServerBrowserContext;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContext;
import org.keycloak.testsuite.util.ServerURLs;

public class URLProvider
extends URLResourceProvider {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    @Inject
    Instance<SuiteContext> suiteContext;
    @Inject
    Instance<TestContext> testContext;

    public Object doLookup(ArquillianResource resource, Annotation ... qualifiers) {
        URL url = (URL)super.doLookup(resource, qualifiers);
        if (url == null) {
            Annotation[] appServerContextRoot = ServerURLs.getAppServerContextRoot();
            try {
                Annotation[] annotationArray = qualifiers;
                int n = annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    Annotation a = annotationArray[i];
                    if (!OperateOnDeployment.class.isAssignableFrom(a.annotationType())) continue;
                    return new URL((String)appServerContextRoot + "/" + ((OperateOnDeployment)a).value() + "/");
                }
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
        for (Annotation a : qualifiers) {
            ContainerInfo appServerInfo;
            if (AuthServerContext.class.isAssignableFrom(a.annotationType())) {
                return ((SuiteContext)this.suiteContext.get()).getAuthServerInfo().getContextRoot();
            }
            if (AppServerContext.class.isAssignableFrom(a.annotationType())) {
                appServerInfo = ((TestContext)this.testContext.get()).getAppServerInfo();
                if (appServerInfo != null) {
                    return appServerInfo.getContextRoot();
                }
                List<ContainerInfo> appServerBackendsInfo = ((TestContext)this.testContext.get()).getAppServerBackendsInfo();
                if (appServerBackendsInfo.isEmpty()) {
                    throw new IllegalStateException("Both testContext's appServerInfo and appServerBackendsInfo not set.");
                }
                return appServerBackendsInfo.get(0).getContextRoot();
            }
            if (AuthServerBrowserContext.class.isAssignableFrom(a.annotationType())) {
                return ((SuiteContext)this.suiteContext.get()).getAuthServerInfo().getBrowserContextRoot();
            }
            if (!AppServerBrowserContext.class.isAssignableFrom(a.annotationType())) continue;
            appServerInfo = ((TestContext)this.testContext.get()).getAppServerInfo();
            if (appServerInfo != null) {
                return appServerInfo.getBrowserContextRoot();
            }
            List<ContainerInfo> appServerBackendsInfo = ((TestContext)this.testContext.get()).getAppServerBackendsInfo();
            if (appServerBackendsInfo.isEmpty()) {
                throw new IllegalStateException("Both testContext's appServerInfo and appServerBackendsInfo not set.");
            }
            return appServerBackendsInfo.get(0).getBrowserContextRoot();
        }
        if (url != null) {
            try {
                url = new URIBuilder(url.toURI()).setScheme(ServerURLs.APP_SERVER_SCHEME).setHost(ServerURLs.APP_SERVER_HOST).setPort(Integer.parseInt(ServerURLs.APP_SERVER_PORT)).build().toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
        return url;
    }
}

