/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.provider;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import org.keycloak.testsuite.arquillian.LoadBalancerController;
import org.keycloak.testsuite.arquillian.annotation.LoadBalancer;

public class LoadBalancerControllerProvider
implements ResourceProvider {
    @Inject
    private Instance<ContainerRegistry> registry;

    public boolean canProvide(Class<?> type) {
        return type.equals(LoadBalancerController.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        String balancerName = null;
        for (Annotation a : qualifiers) {
            Class<? extends Annotation> annotationType = a.annotationType();
            if (!annotationType.equals(LoadBalancer.class)) continue;
            balancerName = ((LoadBalancer)a).value();
        }
        ContainerRegistry reg = (ContainerRegistry)this.registry.get();
        Container container = null;
        if (balancerName == null || "".equals(balancerName.trim())) {
            if (reg.getContainers().size() != 1) throw new IllegalArgumentException("Invalid load balancer configuration request - need to specify load balancer name in @LoadBalancerController");
            container = (Container)reg.getContainers().get(0);
        } else {
            container = reg.getContainer(balancerName);
        }
        if (container == null) {
            throw new IllegalArgumentException("Invalid load balancer configuration - load balancer not found: '" + balancerName + "'");
        }
        if (container.getDeployableContainer() instanceof LoadBalancerController) return container.getDeployableContainer();
        throw new IllegalArgumentException("Invalid load balancer configuration - container " + container.getName() + " is not a load balancer");
    }
}

