/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.migration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.testsuite.util.OAuthClient;

public class MigrationContext {
    public static final Logger logger = Logger.getLogger(MigrationContext.class);

    public String loadOfflineToken() throws Exception {
        String file = this.getOfflineTokenLocation();
        logger.infof("Reading previously saved offline token from the file: %s", (Object)file);
        try (FileInputStream fis = new FileInputStream(file);){
            String offlineToken = StreamUtil.readString((InputStream)fis, (Charset)Charset.forName("UTF-8"));
            logger.infof("Successfully read offline token: %s", (Object)offlineToken);
            File f = new File(file);
            f.delete();
            logger.infof("Deleted file with offline token: %s", (Object)file);
            String string = offlineToken;
            return string;
        }
    }

    public void runPreMigrationTask() throws Exception {
        String offlineToken = this.requestOfflineToken();
        this.saveOfflineToken(offlineToken);
    }

    private String requestOfflineToken() {
        logger.info((Object)"Requesting offline token on the old container");
        try {
            OAuthClient oauth = new OAuthClient();
            oauth.init(null);
            oauth.scope("offline_access");
            oauth.realm("Migration");
            oauth.clientId("migration-test-client");
            OAuthClient.AccessTokenResponse tokenResponse = oauth.doGrantAccessTokenRequest("secret", "offline-test-user", "password2");
            return tokenResponse.getRefreshToken();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void saveOfflineToken(String offlineToken) throws Exception {
        String file = this.getOfflineTokenLocation();
        logger.infof("Saving offline token to file: %s, Offline token is: %s", (Object)file, (Object)offlineToken);
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));){
            writer.print(offlineToken);
        }
    }

    private String getOfflineTokenLocation() {
        String tmpDir = System.getProperty("java.io.tmpdir", "");
        if (tmpDir == null) {
            tmpDir = System.getProperty("basedir");
        }
        return tmpDir + "/offline-token.txt";
    }
}

