/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.jmx;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.arquillian.jmx.JmxConnectorRegistry;

public class JmxConnectorRegistryCreator {
    private final Logger log = Logger.getLogger(JmxConnectorRegistryCreator.class);
    @Inject
    @ApplicationScoped
    private InstanceProducer<JmxConnectorRegistry> connectorRegistry;

    public void configureJmxConnectorRegistry(@Observes BeforeSuite event) {
        if (this.connectorRegistry.get() == null) {
            this.connectorRegistry.set((Object)new JmxConnectorRegistry(){
                private volatile ConcurrentMap<JMXServiceURL, JMXConnector> connectors = new ConcurrentHashMap<JMXServiceURL, JMXConnector>();

                private JMXConnector createConnection(JMXServiceURL key) {
                    try {
                        JMXConnector conn = JMXConnectorFactory.newJMXConnector(key, null);
                        conn.connect();
                        JmxConnectorRegistryCreator.this.log.infof("Connected to JMX Service URL: %s", (Object)key);
                        return conn;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Could not instantiate JMX connector for " + key, ex);
                    }
                }

                @Override
                public JMXConnector getConnection(JMXServiceURL url) {
                    JMXConnector res = this.connectors.computeIfAbsent(url, this::createConnection);
                    try {
                        res.getMBeanServerConnection().getMBeanCount();
                    }
                    catch (IOException ex) {
                        try {
                            res.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.connectors.replace(url, this.createConnection(url));
                    }
                    return res;
                }

                @Override
                public void closeAll() {
                    this.connectors.values().forEach(c -> {
                        try {
                            c.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                    this.connectors.clear();
                }
            });
        }
    }
}

