/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.decider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.execution.ExecutionDecision;
import org.jboss.arquillian.test.spi.execution.TestExecutionDecider;
import org.keycloak.testsuite.arquillian.AppServerTestEnricher;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;

public class AuthServerExcludeExecutionDecider
implements TestExecutionDecider {
    @Inject
    private Instance<TestContext> testContextInstance;

    public int precedence() {
        return 4;
    }

    public ExecutionDecision decide(Method method) {
        if (AppServerTestEnricher.isRemoteAppServer()) {
            return ExecutionDecision.execute();
        }
        TestContext testContext = (TestContext)this.testContextInstance.get();
        if (method.isAnnotationPresent(AuthServerContainerExclude.class)) {
            List<AuthServerContainerExclude.AuthServer> excluded = Arrays.asList(method.getAnnotation(AuthServerContainerExclude.class).value());
            if (AuthServerTestEnricher.isAuthServerRemote() && excluded.contains((Object)AuthServerContainerExclude.AuthServer.REMOTE)) {
                return ExecutionDecision.dontExecute((String)"Excluded by @AuthServerContainerExclude.");
            }
            if (AuthServerTestEnricher.isAuthServerQuarkus() && excluded.contains((Object)AuthServerContainerExclude.AuthServer.QUARKUS)) {
                return ExecutionDecision.dontExecute((String)"Excluded by @AuthServerContainerExclude.");
            }
        } else if (testContext.getTestClass().isAnnotationPresent(AuthServerContainerExclude.class)) {
            List<AuthServerContainerExclude.AuthServer> excluded = Arrays.asList(testContext.getTestClass().getAnnotation(AuthServerContainerExclude.class).value());
            if (AuthServerTestEnricher.isAuthServerRemote() && excluded.contains((Object)AuthServerContainerExclude.AuthServer.REMOTE)) {
                return ExecutionDecision.dontExecute((String)"Excluded by @AuthServerContainerExclude.");
            }
            if (AuthServerTestEnricher.isAuthServerQuarkus() && excluded.contains((Object)AuthServerContainerExclude.AuthServer.QUARKUS)) {
                return ExecutionDecision.dontExecute((String)"Excluded by @AuthServerContainerExclude.");
            }
        }
        return ExecutionDecision.execute();
    }
}

