/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.containers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.container.impl.ContainerCreationException;
import org.jboss.arquillian.container.impl.ContainerImpl;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.core.spi.Validate;
import org.keycloak.testsuite.arquillian.containers.RegistryCreator;
import org.keycloak.testsuite.arquillian.containers.SecurityActions;

public class Registry
implements ContainerRegistry {
    private final List<Container> containers = new ArrayList<Container>();
    private final Injector injector;
    private static final Logger logger = Logger.getLogger(RegistryCreator.class.getName());

    public Registry(Injector injector) {
        this.injector = injector;
    }

    public Container create(ContainerDef definition, ServiceLoader loader) {
        Validate.notNull((Object)definition, (String)"Definition must be specified");
        try {
            logger.log(Level.FINE, "Registering container: {0}", definition.getContainerName());
            Collection containerAdapters = loader.all(DeployableContainer.class);
            DeployableContainer<?> dcService = null;
            if (containerAdapters.size() == 1) {
                dcService = (DeployableContainer<?>)containerAdapters.iterator().next();
            } else {
                Container domainContainer = this.domainContainer(loader, definition);
                if (domainContainer != null) {
                    return domainContainer;
                }
                if (dcService == null) {
                    dcService = RegistryCreator.getContainerAdapter(RegistryCreator.getAdapterImplClassValue(definition), containerAdapters);
                }
                if (dcService == null) {
                    throw new ConfigurationException("Unable to get container adapter from Arquillian configuration.");
                }
            }
            return this.addContainer((Container)this.injector.inject((Object)new ContainerImpl(definition.getContainerName(), dcService, definition)));
        }
        catch (ConfigurationException e) {
            throw new ContainerCreationException("Could not create Container " + definition.getContainerName(), (Throwable)e);
        }
    }

    private Container domainContainer(ServiceLoader loader, ContainerDef definition) {
        for (Container container : this.containers) {
            String adapterImplClassValue = (String)container.getContainerConfiguration().getContainerProperties().get("adapterImplClass");
            if (!this.isServiceLoaderClassAssignableFromAdapterImplClass(loader, adapterImplClassValue.trim())) continue;
            try {
                return this.addContainer((Container)this.injector.inject((Object)new ContainerImpl(definition.getContainerName(), (DeployableContainer)loader.onlyOne(DeployableContainer.class), definition)));
            }
            catch (Exception ex) {
                throw new ContainerCreationException("Could not create Container " + definition.getContainerName(), (Throwable)ex);
            }
        }
        return null;
    }

    private boolean isServiceLoaderClassAssignableFromAdapterImplClass(ServiceLoader loader, String adapterImplClassValue) {
        if (adapterImplClassValue == null && loader == null) {
            return false;
        }
        if (SecurityActions.isClassPresent(adapterImplClassValue)) {
            Class<?> aClass = SecurityActions.loadClass(adapterImplClassValue);
            String loaderClassName = loader.getClass().getName();
            if (loaderClassName.contains("$")) {
                loaderClassName = loaderClassName.substring(0, loaderClassName.indexOf("$"));
            }
            return SecurityActions.loadClass(loaderClassName).isAssignableFrom(aClass);
        }
        return false;
    }

    public List<Container> getContainers() {
        return Collections.unmodifiableList(new ArrayList<Container>(this.containers));
    }

    public Container getContainer(TargetDescription target) {
        Validate.notNull((Object)target, (String)"Target must be specified");
        if (TargetDescription.DEFAULT.equals((Object)target)) {
            return this.findDefaultContainer();
        }
        return this.findMatchingContainer(target.getName());
    }

    private Container addContainer(Container container) {
        this.containers.add(container);
        return container;
    }

    private Container findDefaultContainer() {
        if (this.containers.size() == 1) {
            return this.containers.get(0);
        }
        for (Container container : this.containers) {
            if (!container.getContainerConfiguration().isDefault()) continue;
            return container;
        }
        return null;
    }

    private Container findMatchingContainer(String name) {
        for (Container container : this.containers) {
            if (!container.getName().equals(name)) continue;
            return container;
        }
        return null;
    }

    public Container getContainer(String name) {
        return this.findMatchingContainer(name);
    }
}

