/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.containers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.containers.KeycloakQuarkusConfiguration;

public class KeycloakQuarkusServerDeployableContainer
implements DeployableContainer<KeycloakQuarkusConfiguration> {
    private static final Logger log = Logger.getLogger(KeycloakQuarkusServerDeployableContainer.class);
    private KeycloakQuarkusConfiguration configuration;
    private Process container;
    private static AtomicBoolean restart = new AtomicBoolean();
    @Inject
    private Instance<SuiteContext> suiteContext;
    private List<String> additionalBuildArgs = Collections.emptyList();

    public Class<KeycloakQuarkusConfiguration> getConfigurationClass() {
        return KeycloakQuarkusConfiguration.class;
    }

    public void setup(KeycloakQuarkusConfiguration configuration) {
        this.configuration = configuration;
    }

    public void start() throws LifecycleException {
        try {
            this.container = this.startContainer();
            this.waitForReadiness();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() throws LifecycleException {
        this.container.destroy();
        try {
            this.container.waitFor(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.container.destroyForcibly();
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        return null;
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        log.infof("Trying to deploy: " + archive.getName(), new Object[0]);
        try {
            this.deployArchiveToServer(archive);
            this.restartServer();
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        return new ProtocolMetaData();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        File wrkDir = this.configuration.getProvidersPath().resolve("providers").toFile();
        try {
            Files.deleteIfExists(wrkDir.toPath().resolve(archive.getName()));
            this.restartServer();
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
    }

    private Process startContainer() throws IOException {
        ProcessBuilder pb = new ProcessBuilder(this.getProcessCommands());
        File wrkDir = this.configuration.getProvidersPath().resolve("bin").toFile();
        ProcessBuilder builder = pb.directory(wrkDir).inheritIO().redirectErrorStream(true);
        String javaOpts = this.configuration.getJavaOpts();
        if (javaOpts != null) {
            builder.environment().put("JAVA_OPTS", javaOpts);
        }
        builder.environment().put("KEYCLOAK_ADMIN", "admin");
        builder.environment().put("KEYCLOAK_ADMIN_PASSWORD", "admin");
        if (restart.compareAndSet(false, true)) {
            FileUtils.deleteDirectory((File)this.configuration.getProvidersPath().resolve("data").toFile());
        }
        return builder.start();
    }

    private String[] getProcessCommands() {
        String cacheMode;
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("./kc.sh");
        commands.add("start");
        commands.add("-Dquarkus.http.root-path=/auth");
        commands.add("--auto-build");
        commands.add("--http-enabled=true");
        if (Boolean.parseBoolean(System.getProperty("auth.server.debug", "false"))) {
            commands.add("--debug");
            if (this.configuration.getDebugPort() > 0) {
                commands.add(Integer.toString(this.configuration.getDebugPort()));
            } else {
                commands.add(System.getProperty("auth.server.debug.port", "5005"));
            }
        }
        commands.add("--http-port=" + this.configuration.getBindHttpPort());
        commands.add("--https-port=" + this.configuration.getBindHttpsPort());
        if (this.configuration.getRoute() != null) {
            commands.add("-Djboss.node.name=" + this.configuration.getRoute());
        }
        if ("local".equals(cacheMode = System.getProperty("auth.server.quarkus.cluster.config", "local"))) {
            commands.add("--cache=local");
        } else {
            commands.add("--cache-config-file=cluster-" + cacheMode + ".xml");
        }
        commands.addAll(this.getAdditionalBuildArgs());
        return commands.toArray(new String[0]);
    }

    private void waitForReadiness() throws MalformedURLException, LifecycleException {
        SuiteContext suiteContext = (SuiteContext)this.suiteContext.get();
        URL contextRoot = new URL(this.getBaseUrl(suiteContext) + "/auth/realms/master/");
        long startTime = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() - startTime > this.getStartTimeout()) {
                this.stop();
                throw new IllegalStateException("Timeout [" + this.getStartTimeout() + "] while waiting for Quarkus server");
            }
            try {
                HttpURLConnection connection;
                Thread.sleep(1000L);
                if ("https".equals(contextRoot.getProtocol())) {
                    connection = (HttpURLConnection)contextRoot.openConnection();
                    HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                    httpsConnection.setSSLSocketFactory(this.createInsecureSslSocketFactory());
                    httpsConnection.setHostnameVerifier(this.createInsecureHostnameVerifier());
                } else {
                    connection = (HttpURLConnection)contextRoot.openConnection();
                }
                connection.setReadTimeout((int)this.getStartTimeout());
                connection.setConnectTimeout((int)this.getStartTimeout());
                connection.connect();
                if (connection.getResponseCode() == 200) break;
                connection.disconnect();
            }
            catch (Exception exception) {}
        }
        log.infof("Keycloak is ready at %s", (Object)contextRoot);
    }

    private URL getBaseUrl(SuiteContext suiteContext) throws MalformedURLException {
        URL baseUrl = suiteContext.getAuthServerInfo().getContextRoot();
        baseUrl = "https".equals(baseUrl.getProtocol()) ? new URL(baseUrl.toString().replace(String.valueOf(baseUrl.getPort()), String.valueOf(this.configuration.getBindHttpsPort()))) : new URL(baseUrl.toString().replace(String.valueOf(baseUrl.getPort()), String.valueOf(this.configuration.getBindHttpPort())));
        return baseUrl;
    }

    private HostnameVerifier createInsecureHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        };
    }

    private SSLSocketFactory createInsecureSslSocketFactory() throws IOException {
        SSLSocketFactory socketFactory;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            socketFactory = sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IOException("Can't create unsecure trust manager");
        }
        return socketFactory;
    }

    private long getStartTimeout() {
        return TimeUnit.SECONDS.toMillis(this.configuration.getStartupTimeoutInSeconds());
    }

    public void resetConfiguration() {
        this.additionalBuildArgs = Collections.emptyList();
    }

    private void deployArchiveToServer(Archive<?> archive) throws IOException {
        File providersDir = this.configuration.getProvidersPath().resolve("providers").toFile();
        InputStream zipStream = ((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream();
        Files.copy(zipStream, providersDir.toPath().resolve(archive.getName()), StandardCopyOption.REPLACE_EXISTING);
    }

    public void restartServer() throws Exception {
        this.stop();
        this.start();
    }

    public List<String> getAdditionalBuildArgs() {
        return this.additionalBuildArgs;
    }

    public void setAdditionalBuildArgs(List<String> newArgs) {
        this.additionalBuildArgs = newArgs;
    }
}

