/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.containers;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.spi.event.StartContainer;
import org.jboss.arquillian.container.spi.event.StopContainer;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.junit.Assert;
import org.keycloak.common.Profile;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.arquillian.annotation.DisableFeatures;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.arquillian.annotation.EnableFeatures;
import org.keycloak.testsuite.arquillian.annotation.SetDefaultProvider;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.util.SpiProvidersSwitchingUtils;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public class KeycloakContainerFeaturesController {
    @Inject
    private Instance<TestContext> testContextInstance;
    @Inject
    private Instance<SuiteContext> suiteContextInstance;
    @Inject
    private Event<StartContainer> startContainerEvent;
    @Inject
    private Event<StopContainer> stopContainerEvent;

    public void restartAuthServer() throws Exception {
        if (AuthServerTestEnricher.isAuthServerRemote()) {
            try (OnlineManagementClient client = AuthServerTestEnricher.getManagementClient();){
                int timeoutInSec = Integer.getInteger(System.getProperty("auth.server.jboss.startup.timeout"), 300);
                Administration administration = new Administration(client, timeoutInSec);
                administration.reload();
            }
        } else {
            this.stopContainerEvent.fire((Object)new StopContainer(((SuiteContext)this.suiteContextInstance.get()).getAuthServerInfo().getArquillianContainer()));
            this.startContainerEvent.fire((Object)new StartContainer(((SuiteContext)this.suiteContextInstance.get()).getAuthServerInfo().getArquillianContainer()));
        }
    }

    private void updateFeatures(Set<UpdateFeature> updateFeatures) throws Exception {
        updateFeatures = updateFeatures.stream().filter(this::skipForProduct).collect(Collectors.toSet());
        updateFeatures.forEach(UpdateFeature::performAction);
        if (updateFeatures.stream().anyMatch(updateFeature -> !((UpdateFeature)updateFeature).skipRestart)) {
            this.restartAuthServer();
            ((TestContext)this.testContextInstance.get()).reconnectAdminClient();
        }
        updateFeatures.forEach(rec$ -> ((UpdateFeature)rec$).assertPerformed());
    }

    private boolean skipForProduct(UpdateFeature feature) {
        return !feature.onlyForProduct || Profile.getName().equals("product");
    }

    private void checkAnnotatedElementForFeatureAnnotations(AnnotatedElement annotatedElement, State state) throws Exception {
        HashSet<UpdateFeature> updateFeatureSet = new HashSet<UpdateFeature>();
        updateFeatureSet.addAll(this.getUpdateFeaturesSet(annotatedElement, state));
        if (annotatedElement instanceof Class) {
            for (Class clazz = ((Class)annotatedElement).getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
                updateFeatureSet.addAll(this.getUpdateFeaturesSet(clazz, state));
            }
        }
        if (!updateFeatureSet.isEmpty()) {
            this.updateFeatures(updateFeatureSet);
        }
    }

    private Set<UpdateFeature> getUpdateFeaturesSet(AnnotatedElement annotatedElement, State state) {
        HashSet<UpdateFeature> ret = new HashSet<UpdateFeature>();
        ret.addAll(Arrays.stream(annotatedElement.getAnnotationsByType(EnableFeature.class)).map(annotation -> new UpdateFeature(annotation.value(), annotation.skipRestart(), state == State.BEFORE ? FeatureAction.ENABLE : FeatureAction.DISABLE, annotation.onlyForProduct(), annotatedElement)).collect(Collectors.toSet()));
        ret.addAll(Arrays.stream(annotatedElement.getAnnotationsByType(DisableFeature.class)).map(annotation -> new UpdateFeature(annotation.value(), annotation.skipRestart(), state == State.BEFORE ? FeatureAction.DISABLE : FeatureAction.ENABLE, annotation.onlyForProduct(), annotatedElement)).collect(Collectors.toSet()));
        return ret;
    }

    private boolean isEnableFeature(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(EnableFeatures.class) || annotatedElement.isAnnotationPresent(EnableFeature.class);
    }

    private boolean isDisableFeature(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(DisableFeatures.class) || annotatedElement.isAnnotationPresent(DisableFeature.class);
    }

    private boolean shouldExecuteAsLast(AnnotatedElement annotatedElement) {
        if (this.isEnableFeature(annotatedElement)) {
            return Arrays.stream(annotatedElement.getAnnotationsByType(EnableFeature.class)).anyMatch(EnableFeature::executeAsLast);
        }
        if (this.isDisableFeature(annotatedElement)) {
            return Arrays.stream(annotatedElement.getAnnotationsByType(DisableFeature.class)).anyMatch(DisableFeature::executeAsLast);
        }
        return false;
    }

    public void handleEnableFeaturesAnnotationBeforeClass(@Observes(precedence=1) BeforeClass event) throws Exception {
        this.checkAnnotatedElementForFeatureAnnotations(event.getTestClass().getJavaClass(), State.BEFORE);
    }

    public void handleEnableFeaturesAnnotationBeforeTest(@Observes(precedence=1) Before event) throws Exception {
        if (!this.shouldExecuteAsLast(event.getTestMethod())) {
            this.checkAnnotatedElementForFeatureAnnotations(event.getTestMethod(), State.BEFORE);
        }
    }

    public void handleChangeStateFeaturePriorityBeforeTest(@Observes(precedence=-100) Before event) throws Exception {
        if (this.shouldExecuteAsLast(event.getTestMethod())) {
            this.checkAnnotatedElementForFeatureAnnotations(event.getTestMethod(), State.BEFORE);
        }
    }

    public void handleEnableFeaturesAnnotationAfterTest(@Observes(precedence=2) After event) throws Exception {
        this.checkAnnotatedElementForFeatureAnnotations(event.getTestMethod(), State.AFTER);
    }

    public void handleEnableFeaturesAnnotationAfterClass(@Observes(precedence=2) AfterClass event) throws Exception {
        this.checkAnnotatedElementForFeatureAnnotations(event.getTestClass().getJavaClass(), State.AFTER);
    }

    private class UpdateFeature {
        private Profile.Feature feature;
        private boolean skipRestart;
        private FeatureAction action;
        private boolean onlyForProduct;
        private final AnnotatedElement annotatedElement;

        public UpdateFeature(Profile.Feature feature, boolean skipRestart, FeatureAction action, boolean onlyForProduct, AnnotatedElement annotatedElement) {
            this.feature = feature;
            this.skipRestart = skipRestart;
            this.action = action;
            this.onlyForProduct = onlyForProduct;
            this.annotatedElement = annotatedElement;
        }

        private void assertPerformed() {
            Assert.assertThat((String)("An annotation requested to " + this.action.name() + " feature " + this.feature.name() + ", however after performing this operation the feature is not in desired state"), (Object)ProfileAssume.isFeatureEnabled(this.feature), (Matcher)CoreMatchers.is((Object)(this.action == FeatureAction.ENABLE ? 1 : 0)));
        }

        public void performAction() {
            if (this.action == FeatureAction.ENABLE && !ProfileAssume.isFeatureEnabled(this.feature) || this.action == FeatureAction.DISABLE && ProfileAssume.isFeatureEnabled(this.feature)) {
                this.action.accept(((TestContext)KeycloakContainerFeaturesController.this.testContextInstance.get()).getTestingClient(), this.feature);
                SetDefaultProvider setDefaultProvider = this.annotatedElement.getAnnotation(SetDefaultProvider.class);
                if (setDefaultProvider != null) {
                    try {
                        if (this.action == FeatureAction.ENABLE) {
                            SpiProvidersSwitchingUtils.addProviderDefaultValue((SuiteContext)KeycloakContainerFeaturesController.this.suiteContextInstance.get(), setDefaultProvider);
                        } else {
                            SpiProvidersSwitchingUtils.removeProvider((SuiteContext)KeycloakContainerFeaturesController.this.suiteContextInstance.get(), setDefaultProvider);
                        }
                    }
                    catch (Exception cause) {
                        throw new RuntimeException("Failed to (un)set default provider", cause);
                    }
                }
            }
        }

        public Profile.Feature getFeature() {
            return this.feature;
        }

        public boolean isSkipRestart() {
            return this.skipRestart;
        }

        public FeatureAction getAction() {
            return this.action;
        }

        public boolean isOnlyForProduct() {
            return this.onlyForProduct;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateFeature that = (UpdateFeature)o;
            return this.feature == that.feature;
        }

        public int hashCode() {
            return Objects.hash(this.feature);
        }
    }

    public static enum State {
        BEFORE,
        AFTER;

    }

    public static enum FeatureAction {
        ENABLE(KeycloakTestingClient::enableFeature),
        DISABLE(KeycloakTestingClient::disableFeature);

        private BiConsumer<KeycloakTestingClient, Profile.Feature> featureConsumer;

        private FeatureAction(BiConsumer<KeycloakTestingClient, Profile.Feature> featureConsumer) {
            this.featureConsumer = featureConsumer;
        }

        public void accept(KeycloakTestingClient testingClient, Profile.Feature feature) {
            this.featureConsumer.accept(testingClient, feature);
        }
    }
}

