/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.containers;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.keycloak.testsuite.arquillian.containers.InfinispanServerConfiguration;

public class InfinispanServerDeployableContainer
implements DeployableContainer<InfinispanServerConfiguration> {
    protected static final Logger log = Logger.getLogger(InfinispanServerDeployableContainer.class);
    InfinispanServerConfiguration configuration;
    private Process infinispanServerProcess;
    private File pidFile;
    private JMXServiceURL jmxServiceURL;
    public static final Boolean CACHE_SERVER_AUTH = Boolean.parseBoolean(System.getProperty("cache.server.auth", "false"));

    public Class<InfinispanServerConfiguration> getConfigurationClass() {
        return InfinispanServerConfiguration.class;
    }

    public void setup(InfinispanServerConfiguration configuration) {
        this.configuration = configuration;
        this.pidFile = new File(configuration.getInfinispanHome(), "bin/server.pid");
    }

    public void start() throws LifecycleException {
        String javaHome;
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("./server.sh");
        if (this.configuration.getServerConfig() != null) {
            commands.add("-c");
            commands.add(this.configuration.getServerConfig());
        }
        if (this.configuration.getPortOffset() != null && this.configuration.getPortOffset() > 0) {
            commands.add("-o");
            commands.add(this.configuration.getPortOffset().toString());
        }
        commands.add(String.format("-Dcom.sun.management.jmxremote.port=%s", this.configuration.getManagementPort()));
        commands.add("-Dcom.sun.management.jmxremote.authenticate=false");
        commands.add("-Dcom.sun.management.jmxremote.ssl=false");
        ProcessBuilder pb = new ProcessBuilder(commands);
        pb = pb.directory(new File(this.configuration.getInfinispanHome(), "/bin")).inheritIO().redirectErrorStream(true);
        pb.environment().put("LAUNCH_ISPN_IN_BACKGROUND", "false");
        pb.environment().put("ISPN_PIDFILE", this.pidFile.getAbsolutePath());
        if (this.configuration.getJavaVmArguments() != null) {
            pb.environment().put("JAVA_OPTS", this.configuration.getJavaVmArguments());
        }
        if ((javaHome = this.configuration.getJavaHome()) != null && !javaHome.isEmpty()) {
            pb.environment().put("JAVA_HOME", javaHome);
        }
        try {
            log.info((Object)"Starting Infinispan server");
            log.infof("  Home directory: %s", (Object)this.configuration.getInfinispanHome());
            log.infof("  Commands: %s", commands);
            log.infof("  Environment: %s", pb.environment());
            this.infinispanServerProcess = pb.start();
            this.trustAllCertificates();
            long startTimeMillis = System.currentTimeMillis();
            long startupTimeoutMillis = 30000L;
            URL consoleURL = new URL(String.format("%s://localhost:%s/console/", CACHE_SERVER_AUTH != false ? "https" : "http", 11222 + this.configuration.getPortOffset()));
            while (true) {
                Thread.sleep(1000L);
                if (System.currentTimeMillis() > startTimeMillis + startupTimeoutMillis) {
                    this.stop();
                    throw new LifecycleException("Infinispan server startup timed out.");
                }
                HttpURLConnection connection = (HttpURLConnection)consoleURL.openConnection();
                connection.setReadTimeout(1000);
                connection.setConnectTimeout(1000);
                try {
                    connection.connect();
                    if (connection.getResponseCode() == 200) break;
                    connection.disconnect();
                }
                catch (ConnectException connectException) {}
            }
            log.info((Object)"Infinispan server started.");
        }
        catch (IOException ex) {
            throw new LifecycleException("Unable to start Infinispan server.", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            log.error((Object)"Infinispan server startup process interupted.", (Throwable)ex);
            this.stop();
        }
    }

    private void trustAllCertificates() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to initialize a 'trust-all' trust manager.");
        }
    }

    public void stop() throws LifecycleException {
        log.info((Object)"Stopping Infinispan server");
        this.infinispanServerProcess.destroy();
        try {
            this.infinispanServerProcess.waitFor(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.info((Object)"Unable to stop Infinispan server within timeout. Stopping forcibly.");
            this.infinispanServerProcess.destroyForcibly();
        }
        log.info((Object)"Infinispan server stopped");
    }

    private long getPID() throws IOException {
        if (this.pidFile == null) {
            throw new IllegalStateException(String.format("Unable to find PID file '%s'", this.pidFile));
        }
        return Long.parseLong(Files.readAllLines(this.pidFile.toPath()).get(0).trim());
    }

    public JMXServiceURL getJMXServiceURL() throws IOException {
        if (this.jmxServiceURL == null) {
            this.jmxServiceURL = new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://localhost:%s/jmxrmi", this.configuration.getManagementPort()));
        }
        return this.jmxServiceURL;
    }

    public ProtocolDescription getDefaultProtocol() {
        return ProtocolDescription.DEFAULT;
    }

    public ProtocolMetaData deploy(Archive<?> archv) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Archive<?> archv) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void deploy(Descriptor d) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Descriptor d) throws DeploymentException {
        throw new UnsupportedOperationException();
    }
}

