/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.arquillian.AppServerTestEnricher;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.TestCleanup;

public final class TestContext {
    private final SuiteContext suiteContext;
    private final Class testClass;
    private ContainerInfo appServerInfo;
    private final List<ContainerInfo> appServerBackendsInfo = new ArrayList<ContainerInfo>();
    private boolean adminLoggedIn;
    private Keycloak adminClient;
    private KeycloakTestingClient testingClient;
    private List<RealmRepresentation> testRealmReps = new ArrayList<RealmRepresentation>();
    private boolean initialized;
    private final Map<String, TestCleanup> cleanups = new ConcurrentHashMap<String, TestCleanup>();

    public TestContext(SuiteContext suiteContext, Class testClass) {
        this.suiteContext = suiteContext;
        this.testClass = testClass;
        this.adminLoggedIn = false;
    }

    public boolean isAdminLoggedIn() {
        return this.adminLoggedIn;
    }

    public void setAdminLoggedIn(boolean adminLoggedIn) {
        this.adminLoggedIn = adminLoggedIn;
    }

    public ContainerInfo getAppServerInfo() {
        return this.appServerInfo;
    }

    public void setAppServerInfo(ContainerInfo appServerInfo) {
        this.appServerInfo = appServerInfo;
    }

    public List<ContainerInfo> getAppServerBackendsInfo() {
        return this.appServerBackendsInfo;
    }

    public void setAppServerBackendsInfo(List<ContainerInfo> appServerBackendsInfo) {
        Collections.sort(appServerBackendsInfo);
        this.appServerBackendsInfo.addAll(appServerBackendsInfo);
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public void reconnectAdminClient() throws Exception {
        if (this.adminClient != null && !this.adminClient.isClosed()) {
            this.adminClient.close();
        }
        String authServerContextRoot = this.suiteContext.getAuthServerInfo().getContextRoot().toString();
        this.adminClient = AdminClientUtil.createAdminClient(this.suiteContext.isAdapterCompatTesting(), authServerContextRoot);
    }

    public boolean isAdapterTest() {
        return !AppServerTestEnricher.getAppServerQualifiers(this.testClass).isEmpty();
    }

    public boolean isAdapterContainerEnabled() {
        if (!this.isAdapterTest()) {
            return false;
        }
        return AppServerTestEnricher.getAppServerQualifiers(this.testClass).contains("app-server-" + AppServerTestEnricher.CURRENT_APP_SERVER);
    }

    public boolean isAdapterContainerEnabledCluster() {
        if (!this.isAdapterTest()) {
            return false;
        }
        if (this.appServerBackendsInfo.isEmpty()) {
            return false;
        }
        Set<String> appServerQualifiers = AppServerTestEnricher.getAppServerQualifiers(this.testClass);
        String qualifier = this.appServerBackendsInfo.stream().map(ContainerInfo::getQualifier).collect(Collectors.joining(";"));
        return appServerQualifiers.contains(qualifier);
    }

    public boolean isRelativeAdapterTest() {
        return this.isAdapterTest() && this.appServerInfo.getQualifier().equals(this.suiteContext.getAuthServerInfo().getQualifier());
    }

    public SuiteContext getSuiteContext() {
        return this.suiteContext;
    }

    public String toString() {
        return "TEST CONTEXT: " + this.getTestClass().getCanonicalName() + "\n" + (this.isAdapterTest() ? "Activated @AppServerContainer(" + AppServerTestEnricher.getAppServerQualifiers(this.testClass) + ")\n" : "");
    }

    public Keycloak getAdminClient() {
        return this.adminClient;
    }

    public void setAdminClient(Keycloak adminClient) {
        this.adminClient = adminClient;
    }

    public KeycloakTestingClient getTestingClient() {
        if (this.testingClient == null) {
            String authServerContextRoot = this.suiteContext.getAuthServerInfo().getContextRoot().toString();
            this.testingClient = KeycloakTestingClient.getInstance(authServerContextRoot + "/auth");
        }
        return this.testingClient;
    }

    public void setTestingClient(KeycloakTestingClient testingClient) {
        this.testingClient = testingClient;
    }

    public List<RealmRepresentation> getTestRealmReps() {
        return this.testRealmReps;
    }

    public void setTestRealmReps(List<RealmRepresentation> testRealmReps) {
        this.testRealmReps = testRealmReps;
    }

    public void addTestRealmToTestRealmReps(RealmRepresentation testRealmRep) {
        this.testRealmReps.add(testRealmRep);
    }

    public void addTestRealmsToTestRealmReps(List<RealmRepresentation> testRealmReps) {
        this.testRealmReps.addAll(testRealmReps);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public TestCleanup getOrCreateCleanup(String realmName) {
        TestCleanup existing;
        TestCleanup cleanup = this.cleanups.get(realmName);
        if (cleanup == null && (existing = this.cleanups.putIfAbsent(realmName, cleanup = new TestCleanup(this, realmName))) != null) {
            cleanup = existing;
        }
        return cleanup;
    }

    public Map<String, TestCleanup> getCleanups() {
        return this.cleanups;
    }

    public String getAppServerContainerName() {
        if (this.isAdapterContainerEnabled()) {
            return this.getAppServerInfo().getArquillianContainer().getName();
        }
        if (this.isAdapterContainerEnabledCluster()) {
            return this.getAppServerBackendsInfo().stream().map(ContainerInfo::getQualifier).collect(Collectors.joining(";"));
        }
        return null;
    }
}

