/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.TestClassProvider;
import org.keycloak.testsuite.arquillian.migration.MigrationContext;
import org.keycloak.testsuite.util.TextFileChecker;

public final class SuiteContext {
    private final Set<ContainerInfo> container;
    private List<ContainerInfo> authServerInfo = new LinkedList<ContainerInfo>();
    private final List<List<ContainerInfo>> authServerBackendsInfo = new ArrayList<List<ContainerInfo>>();
    private ContainerInfo legacyAuthServerInfo;
    private final List<ContainerInfo> cacheServersInfo = new ArrayList<ContainerInfo>();
    private ContainerInfo migratedAuthServerInfo;
    private final MigrationContext migrationContext = new MigrationContext();
    private ContainerInfo hotRodStoreInfo;
    private boolean adminPasswordUpdated;
    private final Map<String, String> smtpServer = new HashMap<String, String>();
    private TextFileChecker serverLogChecker;
    private TestClassProvider testClassProvider;
    private static final boolean adapterCompatTesting = Boolean.parseBoolean(System.getProperty("testsuite.adapter.compat.testing"));
    public static final boolean BROWSER_STRICT_COOKIES = Boolean.parseBoolean(System.getProperty("browser.strict.cookies"));

    public SuiteContext(Set<ContainerInfo> arquillianContainers) {
        this.container = arquillianContainers;
        this.adminPasswordUpdated = false;
        this.smtpServer.put("from", "server@mail.test");
        this.smtpServer.put("host", "localhost");
        this.smtpServer.put("port", "3025");
    }

    public TextFileChecker getServerLogChecker() {
        return this.serverLogChecker;
    }

    public void setServerLogChecker(TextFileChecker serverLogChecker) {
        this.serverLogChecker = serverLogChecker;
    }

    public TestClassProvider getTestClassProvider() {
        return this.testClassProvider;
    }

    public void setTestClassProvider(TestClassProvider testClassProvider) {
        this.testClassProvider = testClassProvider;
    }

    public boolean isAdminPasswordUpdated() {
        return this.adminPasswordUpdated;
    }

    public void setAdminPasswordUpdated(boolean adminPasswordUpdated) {
        this.adminPasswordUpdated = adminPasswordUpdated;
    }

    public Map<String, String> getSmtpServer() {
        return this.smtpServer;
    }

    public ContainerInfo getAuthServerInfo() {
        return this.getAuthServerInfo(0);
    }

    public ContainerInfo getAuthServerInfo(int dcIndex) {
        return this.authServerInfo.get(dcIndex);
    }

    public List<ContainerInfo> getDcAuthServerInfo() {
        return this.authServerInfo;
    }

    public void setAuthServerInfo(ContainerInfo authServerInfo) {
        this.authServerInfo = new LinkedList<ContainerInfo>();
        this.authServerInfo.add(authServerInfo);
    }

    public void addAuthServerInfo(int dcIndex, ContainerInfo serverInfo) {
        while (dcIndex >= this.authServerInfo.size()) {
            this.authServerInfo.add(null);
        }
        this.authServerInfo.set(dcIndex, serverInfo);
    }

    public void addCacheServerInfo(int dcIndex, ContainerInfo serverInfo) {
        while (dcIndex >= this.cacheServersInfo.size()) {
            this.cacheServersInfo.add(null);
        }
        this.cacheServersInfo.set(dcIndex, serverInfo);
    }

    public List<ContainerInfo> getAuthServerBackendsInfo() {
        return this.getAuthServerBackendsInfo(0);
    }

    public List<ContainerInfo> getAuthServerBackendsInfo(int dcIndex) {
        return this.authServerBackendsInfo.get(dcIndex);
    }

    public List<List<ContainerInfo>> getDcAuthServerBackendsInfo() {
        return this.authServerBackendsInfo;
    }

    public List<ContainerInfo> getCacheServersInfo() {
        return this.cacheServersInfo;
    }

    public void addAuthServerBackendsInfo(int dcIndex, ContainerInfo container) {
        while (dcIndex >= this.authServerBackendsInfo.size()) {
            this.authServerBackendsInfo.add(new LinkedList());
        }
        this.authServerBackendsInfo.get(dcIndex).add(container);
    }

    public ContainerInfo getLegacyAuthServerInfo() {
        return this.legacyAuthServerInfo;
    }

    public void setLegacyAuthServerInfo(ContainerInfo legacyAuthServerInfo) {
        this.legacyAuthServerInfo = legacyAuthServerInfo;
    }

    public ContainerInfo getMigratedAuthServerInfo() {
        return this.migratedAuthServerInfo;
    }

    public MigrationContext getMigrationContext() {
        return this.migrationContext;
    }

    public void setMigratedAuthServerInfo(ContainerInfo migratedAuthServerInfo) {
        this.migratedAuthServerInfo = migratedAuthServerInfo;
    }

    public ContainerInfo getHotRodStoreInfo() {
        return this.hotRodStoreInfo;
    }

    public void setHotRodStoreInfo(ContainerInfo hotRodStoreInfo) {
        this.hotRodStoreInfo = hotRodStoreInfo;
    }

    public boolean isAuthServerCluster() {
        return !this.authServerBackendsInfo.isEmpty();
    }

    public boolean isAuthServerCrossDc() {
        return this.authServerBackendsInfo.size() > 1;
    }

    public boolean isAuthServerMigrationEnabled() {
        return this.migratedAuthServerInfo != null;
    }

    public Set<ContainerInfo> getContainers() {
        return this.container;
    }

    public boolean isAdapterCompatTesting() {
        return adapterCompatTesting;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SUITE CONTEXT:\nAuth server: ");
        if (this.isAuthServerCrossDc()) {
            int i;
            for (i = 0; i < this.authServerInfo.size(); ++i) {
                ContainerInfo frontend = this.authServerInfo.get(i);
                sb.append("\nFrontend (dc=").append(i).append("): ").append(frontend.getQualifier()).append("\n");
            }
            for (i = 0; i < this.authServerBackendsInfo.size(); ++i) {
                int dcIndex = i;
                this.getDcAuthServerBackendsInfo().get(i).forEach(bInfo -> sb.append("Backend (dc=").append(dcIndex).append("): ").append(bInfo).append("\n"));
            }
            for (int dcIndex = 0; dcIndex < this.cacheServersInfo.size(); ++dcIndex) {
                sb.append("CacheServer (dc=").append(dcIndex).append("): ").append(this.getCacheServersInfo().get(dcIndex)).append("\n");
            }
        } else if (this.isAuthServerCluster()) {
            sb.append(this.isAuthServerCluster() ? "\nFrontend: " : "").append(this.getAuthServerInfo().getQualifier()).append(" - ").append(this.getAuthServerInfo().getContextRoot().toExternalForm()).append("\n");
            this.getAuthServerBackendsInfo().forEach(bInfo -> sb.append("  Backend: ").append(bInfo).append(" - ").append(bInfo.getContextRoot().toExternalForm()).append("\n"));
            if (Boolean.parseBoolean(System.getProperty("auth.server.jboss.legacy"))) {
                sb.append("  Legacy:  ").append(this.getLegacyAuthServerInfo()).append("           - ").append(this.getLegacyAuthServerInfo().getContextRoot().toExternalForm()).append("\n");
            }
        } else {
            sb.append(this.getAuthServerInfo().getQualifier()).append("\n");
        }
        if (this.isAuthServerMigrationEnabled()) {
            sb.append("Migrated from: ").append(System.getProperty("migrated.auth.server.version")).append("\n");
        }
        if (this.isAdapterCompatTesting()) {
            sb.append("Adapter backward compatibility testing mode!\n");
        }
        return sb.toString();
    }
}

