/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.test.impl.client.deployment.AnnotationDeploymentScenarioGenerator;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.testsuite.arquillian.AppServerTestEnricher;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.TestContext;

public class DeploymentTargetModifier
extends AnnotationDeploymentScenarioGenerator {
    public static final String AUTH_SERVER_CURRENT = "auth-server-current";
    public static final String APP_SERVER_CURRENT = "app-server-current";
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    @Inject
    private Instance<TestContext> testContext;

    public List<DeploymentDescription> generate(TestClass testClass) {
        TestContext context = (TestContext)this.testContext.get();
        if (context.isAdapterTest() && !context.isAdapterContainerEnabled() && !context.isAdapterContainerEnabledCluster()) {
            return new ArrayList<DeploymentDescription>();
        }
        List deployments = super.generate(testClass);
        this.checkTestDeployments(deployments, testClass, context.isAdapterTest());
        Set<String> appServerQualifiers = AppServerTestEnricher.getAppServerQualifiers(testClass.getJavaClass());
        if (appServerQualifiers.isEmpty()) {
            return deployments;
        }
        String appServerQualifier = appServerQualifiers.stream().filter(q -> q.contains(AppServerTestEnricher.CURRENT_APP_SERVER)).findAny().orElse(null);
        if (appServerQualifier.contains(";")) {
            return deployments;
        }
        if (appServerQualifier != null && !appServerQualifier.isEmpty()) {
            for (DeploymentDescription deployment : deployments) {
                boolean containerMatches;
                boolean bl = containerMatches = deployment.getTarget() != null && deployment.getTarget().getName().startsWith(appServerQualifier);
                if (deployment.getTarget() == null || Objects.equals(deployment.getTarget().getName(), "_DEFAULT_")) {
                    this.log.debug((Object)("Setting target container for " + deployment.getName() + ": " + appServerQualifier));
                    deployment.setTarget(new TargetDescription(appServerQualifier));
                    continue;
                }
                if (containerMatches || deployment.getArchive().getName().equals("run-on-server-classes.war")) continue;
                throw new RuntimeException("Inconsistency found: target container for " + deployment.getName() + " is set to " + deployment.getTarget().getName() + " but the test class targets " + appServerQualifier);
            }
        }
        return deployments;
    }

    private void checkTestDeployments(List<DeploymentDescription> descriptions, TestClass testClass, boolean isAdapterTest) {
        for (DeploymentDescription deployment : descriptions) {
            if (deployment.getTarget() == null) continue;
            String containerQualifier = deployment.getTarget().getName();
            if (AUTH_SERVER_CURRENT.equals(containerQualifier) || !isAdapterTest && "_DEFAULT_".equals(containerQualifier)) {
                String newAuthServerQualifier = AuthServerTestEnricher.AUTH_SERVER_CONTAINER;
                this.updateServerQualifier(deployment, testClass, newAuthServerQualifier);
                continue;
            }
            if (containerQualifier.contains(APP_SERVER_CURRENT)) {
                String suffix = containerQualifier.split(APP_SERVER_CURRENT)[1];
                String newAppServerQualifier = "app-server-" + AppServerTestEnricher.CURRENT_APP_SERVER + "-" + suffix;
                this.updateServerQualifier(deployment, testClass, newAppServerQualifier);
                continue;
            }
            String newServerQualifier = StringPropertyReplacer.replaceProperties((String)containerQualifier);
            if (newServerQualifier.equals(containerQualifier)) continue;
            this.updateServerQualifier(deployment, testClass, newServerQualifier);
        }
    }

    private void updateServerQualifier(DeploymentDescription deployment, TestClass testClass, String newServerQualifier) {
        this.log.infof("Setting target container for deployment %s.%s: %s", (Object)testClass.getName(), (Object)deployment.getName(), (Object)newServerQualifier);
        deployment.setTarget(new TargetDescription(newServerQualifier));
    }
}

