/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.testsuite.arquillian.AppServerTestEnricher;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.utils.annotation.UseServletFilter;
import org.keycloak.testsuite.utils.arquillian.KeycloakDependenciesResolver;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.keycloak.util.JsonSerialization;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Deprecated
public class DeploymentArchiveProcessor
implements ApplicationArchiveProcessor {
    protected final Logger log = Logger.getLogger(DeploymentArchiveProcessor.class);
    private static final boolean AUTH_SERVER_SSL_REQUIRED = Boolean.parseBoolean(System.getProperty("auth.server.ssl.required"));
    private static final boolean APP_SERVER_SSL_REQUIRED = Boolean.parseBoolean(System.getProperty("app.server.ssl.required"));
    public static final String WEBXML_PATH = "/WEB-INF/web.xml";
    public static final String ADAPTER_CONFIG_PATH = "/WEB-INF/keycloak.json";
    public static final String ADAPTER_CONFIG_PATH_TENANT1 = "/WEB-INF/classes/tenant1-keycloak.json";
    public static final String ADAPTER_CONFIG_PATH_TENANT2 = "/WEB-INF/classes/tenant2-keycloak.json";
    public static final String ADAPTER_CONFIG_PATH_JS = "/keycloak.json";
    public static final String SAML_ADAPTER_CONFIG_PATH = "/WEB-INF/keycloak-saml.xml";
    public static final String JBOSS_DEPLOYMENT_XML_PATH = "/WEB-INF/jboss-deployment-structure.xml";
    public static final String SAML_ADAPTER_CONFIG_PATH_TENANT1 = "/WEB-INF/classes/tenant1-keycloak-saml.xml";
    public static final String SAML_ADAPTER_CONFIG_PATH_TENANT2 = "/WEB-INF/classes/tenant2-keycloak-saml.xml";
    @Inject
    @ClassScoped
    private InstanceProducer<TestContext> testContextProducer;

    public void process(Archive<?> archive, TestClass testClass) {
        if (archive.getName().equals("run-on-server-classes.war")) {
            return;
        }
        if (AppServerTestEnricher.isWLSAppServer() || AppServerTestEnricher.isWASAppServer()) {
            this.log.info((Object)("Processing archive " + archive.getName()));
            this.modifyAdapterConfigs(archive, testClass);
            this.modifyWebXml(archive, testClass);
            MavenResolverSystem resolver = Maven.resolver();
            MavenFormatStage dependencies = (MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomEquippedResolveStage)resolver.loadPomFromFile("pom.xml")).importTestDependencies()).resolve("org.apache.httpcomponents:httpclient")).withTransitivity();
            ((WebArchive)((WebArchive)((WebArchive)archive).addAsLibraries(dependencies.asFile())).addClass(AppServerContainer.class)).addClass(UseServletFilter.class);
        }
    }

    protected void modifyAdapterConfigs(Archive<?> archive, TestClass testClass) {
        boolean relative = AppServerTestEnricher.isRelative();
        this.modifyAdapterConfig(archive, ADAPTER_CONFIG_PATH, relative);
        this.modifyAdapterConfig(archive, ADAPTER_CONFIG_PATH_TENANT1, relative);
        this.modifyAdapterConfig(archive, ADAPTER_CONFIG_PATH_TENANT2, relative);
        this.modifyAdapterConfig(archive, ADAPTER_CONFIG_PATH_JS, relative);
        this.modifyAdapterConfig(archive, SAML_ADAPTER_CONFIG_PATH, relative);
        this.modifyAdapterConfig(archive, SAML_ADAPTER_CONFIG_PATH_TENANT1, relative);
        this.modifyAdapterConfig(archive, SAML_ADAPTER_CONFIG_PATH_TENANT2, relative);
    }

    protected void modifyAdapterConfig(Archive<?> archive, String adapterConfigPath, boolean relative) {
        if (archive.contains(adapterConfigPath)) {
            this.log.info((Object)("Modifying adapter config " + adapterConfigPath + " in " + archive.getName()));
            if (adapterConfigPath.endsWith(".xml")) {
                this.log.info((Object)("Modifying saml adapter config in " + archive.getName()));
                Document doc = IOUtil.loadXML((InputStream)archive.get(adapterConfigPath).getAsset().openStream());
                if (AUTH_SERVER_SSL_REQUIRED) {
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SingleSignOnService", (String)"bindingUrl", (String)"8080", (String)System.getProperty("auth.server.https.port"));
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SingleSignOnService", (String)"bindingUrl", (String)"http", (String)"https");
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SingleSignOnService", (String)"assertionConsumerServiceUrl", (String)"8080", (String)System.getProperty("app.server.https.port"));
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SingleSignOnService", (String)"assertionConsumerServiceUrl", (String)"http", (String)"https");
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SingleLogoutService", (String)"postBindingUrl", (String)"8080", (String)System.getProperty("auth.server.https.port"));
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SingleLogoutService", (String)"postBindingUrl", (String)"http", (String)"https");
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SingleLogoutService", (String)"redirectBindingUrl", (String)"8080", (String)System.getProperty("auth.server.https.port"));
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SingleLogoutService", (String)"redirectBindingUrl", (String)"http", (String)"https");
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SP", (String)"logoutPage", (String)"8080", (String)System.getProperty("app.server.https.port"));
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SP", (String)"logoutPage", (String)"http", (String)"https");
                } else {
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SingleSignOnService", (String)"bindingUrl", (String)"8080", (String)System.getProperty("auth.server.http.port"));
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SingleSignOnService", (String)"assertionConsumerServiceUrl", (String)"8080", (String)System.getProperty("app.server.http.port"));
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SingleLogoutService", (String)"postBindingUrl", (String)"8080", (String)System.getProperty("auth.server.http.port"));
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SingleLogoutService", (String)"redirectBindingUrl", (String)"8080", (String)System.getProperty("auth.server.http.port"));
                    IOUtil.modifyDocElementAttribute((Document)doc, (String)"SP", (String)"logoutPage", (String)"8080", (String)System.getProperty("app.server.http.port"));
                }
                archive.add((Asset)new StringAsset(IOUtil.documentToString((Document)doc)), adapterConfigPath);
                ((WebArchive)archive).addAsResource(new File(DeploymentArchiveProcessor.class.getResource("/keystore/keycloak.truststore").getFile()));
            } else {
                try {
                    AdapterConfig adapterConfig = (AdapterConfig)IOUtil.loadJson((InputStream)archive.get(adapterConfigPath).getAsset().openStream(), AdapterConfig.class);
                    adapterConfig.setAuthServerUrl(ServerURLs.getAuthServerContextRoot() + "/auth");
                    if (APP_SERVER_SSL_REQUIRED) {
                        adapterConfig.setSslRequired("all");
                    }
                    archive.add((Asset)new StringAsset(JsonSerialization.writeValueAsPrettyString((Object)adapterConfig)), adapterConfigPath);
                }
                catch (IOException ex) {
                    this.log.error((Object)"Cannot serialize adapter config to JSON.", (Throwable)ex);
                }
            }
        }
    }

    public void addFilterDependencies(Archive<?> archive, TestClass testClass) {
        TestContext testContext = (TestContext)this.testContextProducer.get();
        if (testContext.getAppServerInfo().isUndertow()) {
            return;
        }
        Node jbossDeploymentStructureXml = archive.get(JBOSS_DEPLOYMENT_XML_PATH);
        if (jbossDeploymentStructureXml == null) {
            this.log.debug((Object)"Archive doesn't contain /WEB-INF/jboss-deployment-structure.xml");
            return;
        }
        this.log.info((Object)("Adding filter dependencies to " + archive.getName()));
        String dependency = ((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).filterDependency();
        ((WebArchive)archive).addAsLibraries(KeycloakDependenciesResolver.resolveDependencies((String)(dependency + ":" + System.getProperty("project.version"))));
        Document jbossXmlDoc = IOUtil.loadXML((InputStream)jbossDeploymentStructureXml.getAsset().openStream());
        IOUtil.removeNodeByAttributeValue((Document)jbossXmlDoc, (String)"dependencies", (String)"module", (String)"name", (String)"org.keycloak.keycloak-saml-core");
        IOUtil.removeNodeByAttributeValue((Document)jbossXmlDoc, (String)"dependencies", (String)"module", (String)"name", (String)"org.keycloak.keycloak-adapter-spi");
        archive.add((Asset)new StringAsset(IOUtil.documentToString((Document)jbossXmlDoc)), JBOSS_DEPLOYMENT_XML_PATH);
    }

    protected void modifyWebXml(Archive<?> archive, TestClass testClass) {
        Document webXmlDoc;
        if (!archive.contains(WEBXML_PATH)) {
            return;
        }
        try {
            webXmlDoc = IOUtil.loadXML((InputStream)archive.get(WEBXML_PATH).getAsset().openStream());
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Error when processing " + archive.getName(), ex);
        }
        if (AppServerTestEnricher.isTomcatAppServer()) {
            IOUtil.modifyDocElementValue((Document)webXmlDoc, (String)"auth-method", (String)"KEYCLOAK", (String)"BASIC");
        }
        if (testClass.getJavaClass().isAnnotationPresent(UseServletFilter.class) && archive.contains(JBOSS_DEPLOYMENT_XML_PATH)) {
            this.addFilterDependencies(archive, testClass);
            this.log.info((Object)("Adding filter to " + ((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).filterClass() + " with mapping " + ((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).filterPattern() + " for " + archive.getName()));
            Element filter = webXmlDoc.createElement("filter");
            Element filterName = webXmlDoc.createElement("filter-name");
            Element filterClass = webXmlDoc.createElement("filter-class");
            filterName.setTextContent(((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).filterName());
            filterClass.setTextContent(((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).filterClass());
            filter.appendChild(filterName);
            filter.appendChild(filterClass);
            String keycloakResolverClass = this.getKeycloakResolverClass(webXmlDoc);
            if (keycloakResolverClass != null) {
                Element initParam = webXmlDoc.createElement("init-param");
                Element paramName = webXmlDoc.createElement("param-name");
                paramName.setTextContent("keycloak.config.resolver");
                Element paramValue = webXmlDoc.createElement("param-value");
                paramValue.setTextContent(keycloakResolverClass);
                initParam.appendChild(paramName);
                initParam.appendChild(paramValue);
                filter.appendChild(initParam);
            }
            IOUtil.appendChildInDocument((Document)webXmlDoc, (String)"web-app", (Element)filter);
            this.addInitParam(webXmlDoc, filter, "keycloak.config.skipPattern", ((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).skipPattern());
            this.addInitParam(webXmlDoc, filter, "keycloak.config.idMapper", ((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).idMapper());
            IOUtil.appendChildInDocument((Document)webXmlDoc, (String)"web-app", (Element)filter);
            Element filterMapping = webXmlDoc.createElement("filter-mapping");
            Element urlPattern = webXmlDoc.createElement("url-pattern");
            filterName = webXmlDoc.createElement("filter-name");
            filterName.setTextContent(((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).filterName());
            urlPattern.setTextContent(IOUtil.getElementTextContent((Document)webXmlDoc, (String)"web-app/security-constraint/web-resource-collection/url-pattern"));
            filterMapping.appendChild(filterName);
            filterMapping.appendChild(urlPattern);
            if (!((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).dispatcherType().isEmpty()) {
                Element dispatcher = webXmlDoc.createElement("dispatcher");
                dispatcher.setTextContent(((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).dispatcherType());
                filterMapping.appendChild(dispatcher);
            }
            IOUtil.appendChildInDocument((Document)webXmlDoc, (String)"web-app", (Element)filterMapping);
            IOUtil.removeElementsFromDoc((Document)webXmlDoc, (String)"web-app", (String)"security-constraint");
            IOUtil.removeElementsFromDoc((Document)webXmlDoc, (String)"web-app", (String)"login-config");
            IOUtil.removeElementsFromDoc((Document)webXmlDoc, (String)"web-app", (String)"security-role");
        }
        archive.add((Asset)new StringAsset(IOUtil.documentToString((Document)webXmlDoc)), WEBXML_PATH);
    }

    private void addInitParam(Document webXmlDoc, Element filter, String initParamName, String initParamValue) {
        if (initParamValue != null && !initParamValue.isEmpty()) {
            Element initParam = webXmlDoc.createElement("init-param");
            Element paramName = webXmlDoc.createElement("param-name");
            paramName.setTextContent(initParamName);
            Element paramValue = webXmlDoc.createElement("param-value");
            paramValue.setTextContent(initParamValue);
            initParam.appendChild(paramName);
            initParam.appendChild(paramValue);
            filter.appendChild(initParam);
        }
    }

    private String getKeycloakResolverClass(Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile("//web-app/context-param[param-name='keycloak.config.resolver']/param-value/text()");
            NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            if (nodes != null && nodes.getLength() > 0) {
                return nodes.item(0).getNodeValue();
            }
        }
        catch (DOMException e) {
            throw new IllegalStateException(e);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
        return null;
    }
}

