/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.spi.event.StopContainer;
import org.jboss.arquillian.container.spi.event.StopSuiteContainers;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.annotation.InitialDcState;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.crossdc.DC;
import org.keycloak.testsuite.crossdc.ServerSetup;
import org.keycloak.testsuite.utils.tls.TLSUtils;

public class CrossDCTestEnricher {
    protected static final Logger log = Logger.getLogger(CrossDCTestEnricher.class);
    private static SuiteContext suiteContext;
    @Inject
    private static Instance<ContainerController> containerController;
    @Inject
    private Event<StopContainer> stopContainer;
    private static final Map<ContainerInfo, Keycloak> backendAdminClients;
    private static final Map<ContainerInfo, KeycloakTestingClient> backendTestingClients;

    static void initializeSuiteContext(SuiteContext suiteContext) {
        Validate.notNull((Object)suiteContext, (String)"Suite context cannot be null.");
        CrossDCTestEnricher.suiteContext = suiteContext;
        if (AuthServerTestEnricher.AUTH_SERVER_CROSS_DC && suiteContext.getCacheServersInfo().isEmpty() && !AuthServerTestEnricher.CACHE_SERVER_LIFECYCLE_SKIP) {
            throw new IllegalStateException("Cache containers misconfiguration");
        }
    }

    public void beforeTest(@Observes(precedence=-2) Before event) {
        if (!suiteContext.isAuthServerCrossDc()) {
            return;
        }
        InitialDcState annotation = event.getTestMethod().getAnnotation(InitialDcState.class);
        if (annotation == null) {
            Class annotatedClass = this.getNearestSuperclassWithAnnotation(event.getTestClass().getJavaClass(), InitialDcState.class);
            InitialDcState initialDcState = annotation = annotatedClass == null ? null : annotatedClass.getAnnotation(InitialDcState.class);
        }
        if (annotation == null) {
            log.debug((Object)"No environment preparation requested, not changing auth/cache server run status.");
            return;
        }
        ServerSetup cacheServers = annotation.cacheServers();
        ServerSetup authServers = annotation.authServers();
        switch (authServers) {
            case ALL_NODES_IN_EVERY_DC: {
                break;
            }
            case FIRST_NODE_IN_EVERY_DC: {
                DC.validDcsStream().forEach(dc -> CrossDCTestEnricher.stopAuthServerBackendNode(dc, 1));
                break;
            }
            case FIRST_NODE_IN_FIRST_DC: {
                CrossDCTestEnricher.stopAuthServerBackendNode(DC.FIRST, 1);
                CrossDCTestEnricher.forAllBackendNodesInDc(DC.SECOND, CrossDCTestEnricher::stopAuthServerBackendNode);
                break;
            }
            case ALL_NODES_IN_FIRST_DC_FIRST_NODE_IN_SECOND_DC: {
                CrossDCTestEnricher.stopAuthServerBackendNode(DC.SECOND, 1);
                break;
            }
            case ALL_NODES_IN_FIRST_DC_NO_NODES_IN_SECOND_DC: {
                CrossDCTestEnricher.forAllBackendNodesInDc(DC.SECOND, CrossDCTestEnricher::stopAuthServerBackendNode);
            }
        }
        switch (cacheServers) {
            case ALL_NODES_IN_EVERY_DC: 
            case FIRST_NODE_IN_EVERY_DC: 
            case ALL_NODES_IN_FIRST_DC_FIRST_NODE_IN_SECOND_DC: {
                DC.validDcsStream().forEach(CrossDCTestEnricher::startCacheServer);
                break;
            }
            case FIRST_NODE_IN_FIRST_DC: 
            case ALL_NODES_IN_FIRST_DC_NO_NODES_IN_SECOND_DC: {
                CrossDCTestEnricher.startCacheServer(DC.FIRST);
                CrossDCTestEnricher.stopCacheServer(DC.SECOND);
            }
        }
        switch (authServers) {
            case ALL_NODES_IN_EVERY_DC: {
                CrossDCTestEnricher.forAllBackendNodes(CrossDCTestEnricher::startAuthServerBackendNode);
                break;
            }
            case FIRST_NODE_IN_EVERY_DC: {
                DC.validDcsStream().forEach(dc -> CrossDCTestEnricher.startAuthServerBackendNode(dc, 0));
                break;
            }
            case FIRST_NODE_IN_FIRST_DC: {
                CrossDCTestEnricher.startAuthServerBackendNode(DC.FIRST, 0);
                break;
            }
            case ALL_NODES_IN_FIRST_DC_FIRST_NODE_IN_SECOND_DC: {
                CrossDCTestEnricher.forAllBackendNodesInDc(DC.FIRST, CrossDCTestEnricher::startAuthServerBackendNode);
                CrossDCTestEnricher.startAuthServerBackendNode(DC.SECOND, 0);
                break;
            }
            case ALL_NODES_IN_FIRST_DC_NO_NODES_IN_SECOND_DC: {
                CrossDCTestEnricher.forAllBackendNodesInDc(DC.FIRST, CrossDCTestEnricher::startAuthServerBackendNode);
            }
        }
        CrossDCTestEnricher.suspendPeriodicTasks();
    }

    public void afterTest(@Observes After event) {
        if (!suiteContext.isAuthServerCrossDc()) {
            return;
        }
        CrossDCTestEnricher.restorePeriodicTasks();
    }

    public void afterSuite(@Observes(precedence=4) AfterSuite event) {
        if (!suiteContext.isAuthServerCrossDc()) {
            return;
        }
        CrossDCTestEnricher.forAllBackendNodesStream().map(ContainerInfo::getArquillianContainer).map(StopContainer::new).forEach(arg_0 -> this.stopContainer.fire(arg_0));
        if (!AuthServerTestEnricher.CACHE_SERVER_LIFECYCLE_SKIP) {
            DC.validDcsStream().map(CrossDCTestEnricher::getCacheServer).map(ContainerInfo::getArquillianContainer).map(StopContainer::new).forEach(arg_0 -> this.stopContainer.fire(arg_0));
        }
    }

    public void stopSuiteContainers(@Observes(precedence=4) StopSuiteContainers event) {
        if (!suiteContext.isAuthServerCrossDc()) {
            return;
        }
        CrossDCTestEnricher.forAllBackendNodes(CrossDCTestEnricher::stopAuthServerBackendNode);
        DC.validDcsStream().forEach(CrossDCTestEnricher::stopCacheServer);
    }

    private static void createRESTClientsForNode(ContainerInfo node) {
        if (!backendAdminClients.containsKey(node)) {
            backendAdminClients.put(node, CrossDCTestEnricher.createAdminClientFor(node));
        }
        if (!backendTestingClients.containsKey(node)) {
            backendTestingClients.put(node, CrossDCTestEnricher.createTestingClientFor(node));
        }
    }

    private static void removeRESTClientsForNode(ContainerInfo node) {
        if (backendAdminClients.containsKey(node)) {
            backendAdminClients.get(node).close();
            backendAdminClients.remove(node);
        }
        if (backendTestingClients.containsKey(node)) {
            backendTestingClients.get(node).close();
            backendTestingClients.remove(node);
        }
    }

    public static Map<ContainerInfo, Keycloak> getBackendAdminClients() {
        return Collections.unmodifiableMap(backendAdminClients);
    }

    public static Map<ContainerInfo, KeycloakTestingClient> getBackendTestingClients() {
        return Collections.unmodifiableMap(backendTestingClients);
    }

    private static Keycloak createAdminClientFor(ContainerInfo node) {
        log.info((Object)("--DC: Initializing admin client for " + node.getContextRoot() + "/auth"));
        return Keycloak.getInstance((String)(node.getContextRoot() + "/auth"), (String)"master", (String)"admin", (String)"admin", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());
    }

    private static KeycloakTestingClient createTestingClientFor(ContainerInfo node) {
        log.info((Object)("--DC: Initializing testing client for " + node.getContextRoot() + "/auth"));
        return KeycloakTestingClient.getInstance(node.getContextRoot() + "/auth");
    }

    private static void suspendPeriodicTasks() {
        log.debug((Object)"--DC: suspendPeriodicTasks");
        backendTestingClients.values().stream().forEach(testingClient -> testingClient.testing().suspendPeriodicTasks());
    }

    private static void restorePeriodicTasks() {
        log.debug((Object)"--DC: restorePeriodicTasks");
        backendTestingClients.values().stream().forEach(testingClient -> testingClient.testing().restorePeriodicTasks());
    }

    private static ContainerInfo getCacheServer(DC dc) {
        CrossDCTestEnricher.assertValidDc(dc);
        int dcIndex = dc.ordinal();
        return suiteContext.getCacheServersInfo().get(dcIndex);
    }

    private static void assertValidDc(DC dc) throws IllegalStateException {
        if (dc == DC.UNDEFINED) {
            throw new IllegalStateException("Invalid DC used: " + (Object)((Object)DC.UNDEFINED));
        }
    }

    public static boolean isModularJvm() {
        java.util.regex.Matcher matcher;
        boolean modularJvm = false;
        String javaSpecVersion = System.getProperty("java.specification.version");
        if (javaSpecVersion != null && (matcher = Pattern.compile("^(?:1\\.)?(\\d+)$").matcher(javaSpecVersion)).find()) {
            modularJvm = Integer.parseInt(matcher.group(1)) >= 9;
        }
        return modularJvm;
    }

    public static void startCacheServer(DC dc) {
        if (AuthServerTestEnricher.CACHE_SERVER_LIFECYCLE_SKIP) {
            return;
        }
        if (!((ContainerController)containerController.get()).isStarted(CrossDCTestEnricher.getCacheServer(dc).getQualifier())) {
            log.infof("--DC: Starting %s", (Object)CrossDCTestEnricher.getCacheServer(dc).getQualifier());
            Map<String, String> containerConfig = CrossDCTestEnricher.getCacheServer(dc).getProperties();
            String defaultModularJvmOptions = System.getProperty("default.modular.jvm.options");
            String originalJvmArguments = CrossDCTestEnricher.getCacheServer(dc).getProperties().get("javaVmArguments");
            if (!originalJvmArguments.contains(defaultModularJvmOptions) && CrossDCTestEnricher.isModularJvm() && defaultModularJvmOptions != null) {
                log.infof("Modular JVM detected. Adding default modular JVM '%s' options to the cache server container's configuration.", (Object)defaultModularJvmOptions);
                String lineSeparator = System.getProperty("line.separator");
                String adjustedJvmArguments = originalJvmArguments.replace(lineSeparator, " ") + defaultModularJvmOptions + lineSeparator;
                containerConfig.put("javaVmArguments", adjustedJvmArguments);
            }
            ((ContainerController)containerController.get()).start(CrossDCTestEnricher.getCacheServer(dc).getQualifier(), containerConfig);
            log.infof("--DC: Started %s", (Object)CrossDCTestEnricher.getCacheServer(dc).getQualifier());
        }
    }

    public static void stopCacheServer(DC dc) {
        if (AuthServerTestEnricher.CACHE_SERVER_LIFECYCLE_SKIP) {
            return;
        }
        String qualifier = CrossDCTestEnricher.getCacheServer(dc).getQualifier();
        if (((ContainerController)containerController.get()).isStarted(qualifier)) {
            log.infof("--DC: Stopping %s", (Object)qualifier);
            ((ContainerController)containerController.get()).stop(qualifier);
            String setupCleanServerBaseDir = CrossDCTestEnricher.getContainerProperty(CrossDCTestEnricher.getCacheServer(dc), "setupCleanServerBaseDir");
            String cleanServerBaseDir = CrossDCTestEnricher.getContainerProperty(CrossDCTestEnricher.getCacheServer(dc), "cleanServerBaseDir");
            if (Boolean.parseBoolean(setupCleanServerBaseDir)) {
                log.debugf("Going to clean directory: %s", (Object)cleanServerBaseDir);
                File dir = new File(cleanServerBaseDir);
                if (dir.exists()) {
                    try {
                        dir.renameTo(new File(dir.getParentFile(), dir.getName() + "-backup-" + System.currentTimeMillis()));
                        File deploymentsDir = new File(dir, "deployments");
                        FileUtils.forceMkdir((File)deploymentsDir);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("Failed to clean directory: " + cleanServerBaseDir, ioe);
                    }
                }
            }
            log.infof("--DC: Stopped %s", (Object)qualifier);
        }
    }

    public static void forAllBackendNodes(Consumer<ContainerInfo> functionOnContainerInfo) {
        CrossDCTestEnricher.forAllBackendNodesStream().forEach(functionOnContainerInfo);
    }

    public static Stream<ContainerInfo> forAllBackendNodesStream() {
        return suiteContext.getDcAuthServerBackendsInfo().stream().flatMap(Collection::stream);
    }

    public static void forAllBackendNodesInDc(DC dc, Consumer<ContainerInfo> functionOnContainerInfo) {
        CrossDCTestEnricher.assertValidDc(dc);
        suiteContext.getDcAuthServerBackendsInfo().get(dc.ordinal()).stream().forEach(functionOnContainerInfo);
    }

    public static void stopAuthServerBackendNode(ContainerInfo containerInfo) {
        if (containerInfo.isStarted()) {
            log.infof("--DC: Stopping backend auth-server node: %s", (Object)containerInfo.getQualifier());
            CrossDCTestEnricher.removeRESTClientsForNode(containerInfo);
            ((ContainerController)containerController.get()).stop(containerInfo.getQualifier());
        }
    }

    public static void startAuthServerBackendNode(ContainerInfo containerInfo) {
        if (!containerInfo.isStarted()) {
            log.infof("--DC: Starting backend auth-server node: %s", (Object)containerInfo.getQualifier());
            ((ContainerController)containerController.get()).start(containerInfo.getQualifier());
            AuthServerTestEnricher.initializeTLS(containerInfo);
            CrossDCTestEnricher.createRESTClientsForNode(containerInfo);
        }
    }

    public static ContainerInfo getBackendNode(DC dc, int nodeIndex) {
        CrossDCTestEnricher.assertValidDc(dc);
        int dcIndex = dc.ordinal();
        Assert.assertThat((Object)dcIndex, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(suiteContext.getDcAuthServerBackendsInfo().size())));
        List<ContainerInfo> dcNodes = suiteContext.getDcAuthServerBackendsInfo().get(dcIndex);
        Assert.assertThat((Object)nodeIndex, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(dcNodes.size())));
        return dcNodes.get(nodeIndex);
    }

    public static ContainerInfo startAuthServerBackendNode(DC dc, int nodeIndex) {
        ContainerInfo dcNode = CrossDCTestEnricher.getBackendNode(dc, nodeIndex);
        CrossDCTestEnricher.startAuthServerBackendNode(dcNode);
        return dcNode;
    }

    public static ContainerInfo stopAuthServerBackendNode(DC dc, int nodeIndex) {
        ContainerInfo dcNode = CrossDCTestEnricher.getBackendNode(dc, nodeIndex);
        CrossDCTestEnricher.stopAuthServerBackendNode(dcNode);
        return dcNode;
    }

    private Class getNearestSuperclassWithAnnotation(Class<?> testClass, Class annotationClass) {
        return testClass.isAnnotationPresent(annotationClass) ? testClass : (testClass.getSuperclass().equals(Object.class) ? null : this.getNearestSuperclassWithAnnotation(testClass.getSuperclass(), annotationClass));
    }

    private static String getContainerProperty(ContainerInfo cacheServer, String propertyName) {
        return (String)cacheServer.getArquillianContainer().getContainerConfiguration().getContainerProperties().get(propertyName);
    }

    static {
        backendAdminClients = new HashMap<ContainerInfo, Keycloak>();
        backendTestingClients = new HashMap<ContainerInfo, KeycloakTestingClient>();
    }
}

