/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.io.IOException;
import java.io.NotSerializableException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.MalformedURLException;
import java.rmi.UnmarshalException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Retry;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.InfinispanStatistics;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.annotation.JmxInfinispanCacheStatistics;
import org.keycloak.testsuite.arquillian.annotation.JmxInfinispanChannelStatistics;
import org.keycloak.testsuite.arquillian.containers.InfinispanServerDeployableContainer;
import org.keycloak.testsuite.arquillian.jmx.JmxConnectorRegistry;
import org.keycloak.testsuite.arquillian.undertow.KeycloakOnUndertow;
import org.keycloak.testsuite.crossdc.DC;

public class CacheStatisticsControllerEnricher
implements TestEnricher {
    private static final Logger LOG = Logger.getLogger(CacheStatisticsControllerEnricher.class);
    @Inject
    private Instance<ContainerRegistry> registry;
    @Inject
    private Instance<JmxConnectorRegistry> jmxConnectorRegistry;
    @Inject
    private Instance<SuiteContext> suiteContext;

    public void enrich(Object testCase) {
        Validate.notNull((Object)this.registry.get(), (String)"registry should not be null");
        Validate.notNull((Object)this.jmxConnectorRegistry.get(), (String)"jmxConnectorRegistry should not be null");
        Validate.notNull((Object)this.suiteContext.get(), (String)"suiteContext should not be null");
        for (Field field : FieldUtils.getAllFields(testCase.getClass())) {
            JmxInfinispanCacheStatistics annotation = field.getAnnotation(JmxInfinispanCacheStatistics.class);
            if (annotation == null) continue;
            try {
                FieldUtils.writeField((Field)field, (Object)testCase, (Object)this.getInfinispanCacheStatistics(annotation), (boolean)true);
            }
            catch (IOException | IllegalAccessException | MalformedObjectNameException e) {
                throw new RuntimeException("Could not set value on field " + field);
            }
        }
    }

    private InfinispanStatistics getInfinispanCacheStatistics(JmxInfinispanCacheStatistics annotation) throws MalformedObjectNameException, IOException, MalformedURLException {
        InfinispanCacheStatisticsImpl value;
        block4: {
            LinkedList<ObjectName> mbeanNameTemplates = new LinkedList<ObjectName>();
            mbeanNameTemplates.add(new ObjectName(String.format("%s:type=%s,name=\"%s(%s)\",manager=\"%s\",component=%s", annotation.domain().isEmpty() ? this.getDefaultDomain(annotation.dc().getDcIndex(), annotation.dcNodeIndex()) : "jboss.datagrid-infinispan", annotation.type(), annotation.cacheName(), annotation.cacheMode(), annotation.cacheManagerName(), annotation.component())));
            if (annotation.dc().getDcIndex() != -1 && annotation.dcNodeIndex() != -1) {
                mbeanNameTemplates.add(new ObjectName(String.format("jboss.as:subsystem=infinispan,cache-container=keycloak,cache=%s", annotation.cacheName())));
            }
            value = new InfinispanCacheStatisticsImpl(this.getJmxServerConnection(annotation), mbeanNameTemplates);
            if (annotation.domain().isEmpty()) {
                try {
                    LOG.debug((Object)"Going to try reset InfinispanCacheStatistics (2 attempts, 150 ms interval)");
                    int execute = Retry.execute(() -> value.reset(), (int)2, (long)150L);
                    LOG.debug((Object)("reset in " + execute + " attempts"));
                }
                catch (RuntimeException ex) {
                    if (annotation.dc() == DC.UNDEFINED || annotation.dcNodeIndex() == -1 || !((SuiteContext)this.suiteContext.get()).getAuthServerBackendsInfo(annotation.dc().getDcIndex()).get(annotation.dcNodeIndex()).isStarted()) break block4;
                    LOG.warn((Object)("Could not reset statistics for any of the mbean name templates " + mbeanNameTemplates + ". The reason is: \"" + ex.getMessage() + "\""));
                }
            }
        }
        return value;
    }

    private InfinispanStatistics getJGroupsChannelStatistics(JmxInfinispanChannelStatistics annotation) throws MalformedObjectNameException, IOException, MalformedURLException {
        InfinispanChannelStatisticsImpl value;
        block3: {
            ObjectName mbeanName = new ObjectName(String.format("%s:%stype=%s,cluster=\"%s\"", annotation.domain().isEmpty() ? this.getDefaultDomain(annotation.dc().getDcIndex(), annotation.dcNodeIndex()) : "jboss.datagrid-infinispan", this.isLegacyInfinispan() ? "" : "manager=\"default\",", annotation.type(), annotation.cluster()));
            value = new InfinispanChannelStatisticsImpl(this.getJmxServerConnection(annotation), mbeanName);
            if (annotation.domain().isEmpty()) {
                try {
                    Retry.execute(() -> value.reset(), (int)2, (long)150L);
                }
                catch (RuntimeException ex) {
                    if (annotation.dc() == DC.UNDEFINED || annotation.dcNodeIndex() == -1 || !((SuiteContext)this.suiteContext.get()).getAuthServerBackendsInfo(annotation.dc().getDcIndex()).get(annotation.dcNodeIndex()).isStarted()) break block3;
                    LOG.warn((Object)("Could not reset statistics for " + mbeanName + ". The reason is: \"" + ex.getMessage() + "\""));
                }
            }
        }
        return value;
    }

    public Object[] resolve(Method method) {
        Object[] values = new Object[method.getParameterCount()];
        for (int i = 0; i < method.getParameterCount(); ++i) {
            JmxInfinispanChannelStatistics channelAnnotation;
            Parameter param = method.getParameters()[i];
            JmxInfinispanCacheStatistics annotation = param.getAnnotation(JmxInfinispanCacheStatistics.class);
            if (annotation != null) {
                try {
                    values[i] = this.getInfinispanCacheStatistics(annotation);
                }
                catch (IOException | MalformedObjectNameException e) {
                    throw new RuntimeException("Could not set value on field " + param);
                }
            }
            if ((channelAnnotation = param.getAnnotation(JmxInfinispanChannelStatistics.class)) == null) continue;
            try {
                values[i] = this.getJGroupsChannelStatistics(channelAnnotation);
                continue;
            }
            catch (IOException | MalformedObjectNameException e) {
                throw new RuntimeException("Could not set value on field " + param);
            }
        }
        return values;
    }

    private String getDefaultDomain(int dcIndex, int dcNodeIndex) {
        if (dcIndex != -1 && dcNodeIndex != -1) {
            if (Boolean.parseBoolean(System.getProperty("auth.server.jboss.crossdc"))) {
                return "org.wildfly.clustering.infinispan";
            }
            return "jboss.datagrid-infinispan-" + ((SuiteContext)this.suiteContext.get()).getAuthServerBackendsInfo(dcIndex).get(dcNodeIndex).getQualifier();
        }
        return this.isLegacyInfinispan() ? "jboss.datagrid-infinispan" : "org.infinispan";
    }

    private boolean isLegacyInfinispan() {
        return Boolean.parseBoolean(System.getProperty("cache.server.legacy", "false"));
    }

    private Supplier<MBeanServerConnection> getJmxServerConnection(JmxInfinispanCacheStatistics annotation) throws MalformedURLException {
        int port;
        String host;
        if (annotation.dc() != DC.UNDEFINED && annotation.dcNodeIndex() != -1) {
            ContainerInfo node = ((SuiteContext)this.suiteContext.get()).getAuthServerBackendsInfo(annotation.dc().getDcIndex()).get(annotation.dcNodeIndex());
            Container container = node.getArquillianContainer();
            if (container.getDeployableContainer() instanceof KeycloakOnUndertow) {
                return () -> ManagementFactory.getPlatformMBeanServer();
            }
            host = "localhost";
            port = container.getContainerConfiguration().getContainerProperties().containsKey("managementPort") ? Integer.valueOf((String)container.getContainerConfiguration().getContainerProperties().get("managementPort")) : 9990;
        } else {
            Container container = ((SuiteContext)this.suiteContext.get()).getCacheServersInfo().get(0).getArquillianContainer();
            if (container.getDeployableContainer() instanceof InfinispanServerDeployableContainer) {
                return () -> {
                    try {
                        return ((JmxConnectorRegistry)this.jmxConnectorRegistry.get()).getConnection(((InfinispanServerDeployableContainer)container.getDeployableContainer()).getJMXServiceURL()).getMBeanServerConnection();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                };
            }
            String string = annotation.host().isEmpty() ? System.getProperty(annotation.hostProperty().isEmpty() ? "keycloak.connectionsInfinispan.remoteStoreServer" : annotation.hostProperty()) : (host = annotation.host());
            port = annotation.managementPort() == -1 ? Integer.valueOf(System.getProperty(annotation.managementPortProperty().isEmpty() ? "cache.server.management.port" : annotation.managementPortProperty())).intValue() : annotation.managementPort();
        }
        JMXServiceURL url = new JMXServiceURL("service:jmx:remote+http://" + host + ":" + port);
        return () -> {
            try {
                return ((JmxConnectorRegistry)this.jmxConnectorRegistry.get()).getConnection(url).getMBeanServerConnection();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    private Supplier<MBeanServerConnection> getJmxServerConnection(JmxInfinispanChannelStatistics annotation) throws MalformedURLException {
        int port;
        String host;
        if (annotation.dc() != DC.UNDEFINED && annotation.dcNodeIndex() != -1) {
            ContainerInfo node = ((SuiteContext)this.suiteContext.get()).getAuthServerBackendsInfo(annotation.dc().getDcIndex()).get(annotation.dcNodeIndex());
            Container container = node.getArquillianContainer();
            if (container.getDeployableContainer() instanceof KeycloakOnUndertow) {
                return () -> ManagementFactory.getPlatformMBeanServer();
            }
            host = "localhost";
            port = container.getContainerConfiguration().getContainerProperties().containsKey("managementPort") ? Integer.valueOf((String)container.getContainerConfiguration().getContainerProperties().get("managementPort")) : 9990;
        } else {
            Container container = ((SuiteContext)this.suiteContext.get()).getCacheServersInfo().get(0).getArquillianContainer();
            if (container.getDeployableContainer() instanceof InfinispanServerDeployableContainer) {
                return () -> {
                    try {
                        return ((JmxConnectorRegistry)this.jmxConnectorRegistry.get()).getConnection(((InfinispanServerDeployableContainer)container.getDeployableContainer()).getJMXServiceURL()).getMBeanServerConnection();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                };
            }
            String string = annotation.host().isEmpty() ? System.getProperty(annotation.hostProperty().isEmpty() ? "keycloak.connectionsInfinispan.remoteStoreServer" : annotation.hostProperty()) : (host = annotation.host());
            port = annotation.managementPort() == -1 ? Integer.valueOf(System.getProperty(annotation.managementPortProperty().isEmpty() ? "cache.server.management.port" : annotation.managementPortProperty())).intValue() : annotation.managementPort();
        }
        JMXServiceURL url = new JMXServiceURL("service:jmx:remote+http://" + host + ":" + port);
        return () -> {
            try {
                return ((JmxConnectorRegistry)this.jmxConnectorRegistry.get()).getConnection(url).getMBeanServerConnection();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    private static class InfinispanChannelStatisticsImpl
    extends CacheStatisticsImpl {
        public InfinispanChannelStatisticsImpl(Supplier<MBeanServerConnection> mbscCreator, ObjectName mbeanName) {
            super(mbscCreator, mbeanName);
        }

        @Override
        public void reset() {
            try {
                this.getConnection().invoke(this.getMbeanName(), "resetStats", new Object[0], new String[0]);
            }
            catch (NotSerializableException | UnmarshalException iOException) {
            }
            catch (IOException | InstanceNotFoundException | MBeanException | ReflectionException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        protected boolean isAvailable() {
            return Objects.equals(this.getSingleStatistics("connected"), Boolean.TRUE);
        }
    }

    private static class InfinispanCacheStatisticsImpl
    extends CacheStatisticsImpl {
        public InfinispanCacheStatisticsImpl(Supplier<MBeanServerConnection> mbscCreator, List<ObjectName> mbeanNames) {
            super(mbscCreator, mbeanNames);
        }

        @Override
        public void reset() {
            try {
                this.getConnection().invoke(this.getMbeanName(), "resetStatistics", new Object[0], new String[0]);
            }
            catch (IOException | InstanceNotFoundException | MBeanException | ReflectionException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        protected boolean isAvailable() {
            return this.getSingleStatistics("hits") != null;
        }
    }

    private static abstract class CacheStatisticsImpl
    implements InfinispanStatistics {
        private final Supplier<MBeanServerConnection> mbscCreateor;
        private final List<ObjectName> mbeanNameTemplates;
        private ObjectName mbeanName;

        public CacheStatisticsImpl(Supplier<MBeanServerConnection> mbscCreateor, ObjectName mbeanNameTemplate) {
            this(mbscCreateor, Collections.singletonList(mbeanNameTemplate));
        }

        public CacheStatisticsImpl(Supplier<MBeanServerConnection> mbscCreateor, List<ObjectName> mbeanNameTemplates) {
            this.mbscCreateor = mbscCreateor;
            this.mbeanNameTemplates = mbeanNameTemplates;
        }

        protected MBeanServerConnection getConnection() {
            return this.mbscCreateor.get();
        }

        @Override
        public boolean exists() {
            try {
                this.getMbeanName();
                return true;
            }
            catch (IOException | RuntimeException ex) {
                return false;
            }
        }

        @Override
        public Map<String, Object> getStatistics() {
            try {
                MBeanInfo mBeanInfo = this.getConnection().getMBeanInfo(this.getMbeanName());
                String[] statAttrs = Arrays.asList(mBeanInfo.getAttributes()).stream().filter(MBeanAttributeInfo::isReadable).map(MBeanFeatureInfo::getName).collect(Collectors.toList()).toArray(new String[0]);
                return this.getConnection().getAttributes(this.getMbeanName(), statAttrs).asList().stream().collect(Collectors.toMap(Attribute::getName, Attribute::getValue));
            }
            catch (IOException | InstanceNotFoundException | IntrospectionException | ReflectionException ex) {
                throw new RuntimeException(ex);
            }
        }

        protected ObjectName getMbeanName() throws IOException, RuntimeException {
            if (this.mbeanName == null) {
                for (ObjectName mbeanNameTemplate : this.mbeanNameTemplates) {
                    Set<ObjectName> queryNames = this.getConnection().queryNames(mbeanNameTemplate, null);
                    if (queryNames.isEmpty()) {
                        LOG.infof("No MBean available for the template %s .", (Object)mbeanNameTemplate);
                        continue;
                    }
                    this.mbeanName = queryNames.iterator().next();
                    return this.mbeanName;
                }
                throw new RuntimeException("No MBean for any of the templates " + this.mbeanNameTemplates + " found at JMX server");
            }
            return this.mbeanName;
        }

        @Override
        public Comparable getSingleStatistics(String statisticsName) {
            try {
                return (Comparable)this.getConnection().getAttribute(this.getMbeanName(), statisticsName);
            }
            catch (IOException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void waitToBecomeAvailable(int time, TimeUnit unit) {
            long timeInMillis = TimeUnit.MILLISECONDS.convert(time, unit);
            Retry.execute(() -> {
                try {
                    this.getMbeanName();
                    if (!this.isAvailable()) {
                        throw new RuntimeException("Not available");
                    }
                }
                catch (IOException | RuntimeException ex) {
                    throw new RuntimeException("Timed out while waiting for any of the mbean name templates " + this.mbeanNameTemplates + " to become available", ex);
                }
            }, (int)(1 + (int)timeInMillis / 100), (long)100L);
        }

        protected abstract boolean isAvailable();
    }
}

