/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.testsuite.page.AbstractPageWithInjectedUrl;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;

public abstract class SAMLServlet
extends AbstractPageWithInjectedUrl {
    public void logout() {
        this.driver.navigate().to(this.getUriBuilder().clone().queryParam("GLO", new Object[]{"true"}).build(new Object[0]).toASCIIString());
        WaitUtils.waitForPageToLoad();
    }

    public void checkRoles(boolean check) {
        if (check) {
            this.getUriBuilder().queryParam("checkRoles", new Object[]{true});
        } else {
            this.getUriBuilder().replaceQueryParam("checkRoles", new Object[0]);
        }
    }

    public void checkRolesEndPoint(boolean value) {
        this.driver.navigate().to(this.getUriBuilder().clone().path((value ? "" : "un") + "checkRoles").build(new Object[0]).toASCIIString());
        WaitUtils.waitForPageToLoad();
    }

    public void setRolesToCheck(String roles) {
        UriBuilder uriBuilder = this.getUriBuilder().clone();
        String toASCIIString = uriBuilder.path("setCheckRoles").queryParam("roles", new Object[]{roles}).build(new Object[0]).toASCIIString();
        this.driver.navigate().to(toASCIIString);
        WaitUtils.waitForPageToLoad();
        WaitUtils.waitUntilElement(By.tagName((String)"body")).text().contains("These roles will be checked:");
    }

    public List<String> rolesList() {
        String rolesPattern = this.getFromPageByPattern("Roles");
        if (rolesPattern != null) {
            return Arrays.stream(rolesPattern.split(",")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public String getFromPageByPattern(String text) {
        Pattern p = Pattern.compile(text + ": (.*)");
        Matcher m = p.matcher(this.driver.getPageSource());
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

