/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.page;

import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.wait.ElementBuilder;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.JavascriptBrowser;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;

public class HawtioPage
extends AbstractPage {
    @FindBy(xpath="//a[@class='dropdown-toggle' and @data-original-title='Preferences and log out']")
    @JavascriptBrowser
    private WebElement dropDownMenu;
    @FindBy(xpath="//a[@ng-click='logout()']")
    @JavascriptBrowser
    private WebElement logoutButton;
    @FindBy(xpath="//input[@type='submit' and @value='Yes']")
    @JavascriptBrowser
    private WebElement modal;

    public String getUrl() {
        if (Boolean.parseBoolean(System.getProperty("app.server.ssl.required"))) {
            return "https://localhost:" + System.getProperty("app.server.https.port", "8543") + "/hawtio";
        }
        return "http://localhost:" + System.getProperty("app.server.http.port", "8180") + "/hawtio";
    }

    @Override
    public UriBuilder createUriBuilder() {
        return UriBuilder.fromUri((String)this.getUrl());
    }

    public void logout(WebDriver jsDriver) {
        this.log.debug((Object)"logging out");
        this.hawtioWaitUntil(this.dropDownMenu).is().clickable();
        this.dropDownMenu.click();
        new Actions(jsDriver).moveToElement(this.logoutButton).perform();
        WaitUtils.pause(100L);
        this.hawtioWaitUntil(this.logoutButton).is().clickable();
        this.logoutButton.click();
        this.hawtioWaitUntil(this.modal).is().clickable();
        this.modal.click();
    }

    public ElementBuilder<Void> hawtioWaitUntil(WebElement element) {
        return Graphene.waitGui().withTimeout(3L, TimeUnit.MINUTES).until().element(element);
    }

    public ElementBuilder<Void> hawtioWaitUntil(By element) {
        return Graphene.waitGui().withTimeout(3L, TimeUnit.MINUTES).until().element(element);
    }
}

