/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assume;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.common.Profile;
import org.keycloak.representations.info.ProfileInfoRepresentation;
import org.keycloak.testsuite.util.AdminClientUtil;

public class ProfileAssume {
    private static Set<String> disabledFeatures;
    private static String profile;

    private static void updateProfile() {
        String host = System.getProperty("auth.server.host", "localhost");
        String port = System.getProperty("auth.server.http.port", "8180");
        boolean adapterCompatTesting = Boolean.parseBoolean(System.getProperty("testsuite.adapter.compat.testing"));
        String authServerContextRoot = "http://" + host + ":" + port;
        try (Keycloak adminClient = AdminClientUtil.createAdminClient(adapterCompatTesting, authServerContextRoot);){
            ProfileInfoRepresentation profileInfo = adminClient.serverInfo().getInfo().getProfileInfo();
            profile = profileInfo.getName();
            List disabled = profileInfo.getDisabledFeatures();
            disabledFeatures = Collections.unmodifiableSet(new HashSet(disabled));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to obtain profile / features info from serverinfo endpoint of " + authServerContextRoot, e);
        }
    }

    public static void assumeFeatureEnabled(Profile.Feature feature) {
        ProfileAssume.updateProfile();
        Assume.assumeTrue((String)("Ignoring test as feature " + feature.name() + " is not enabled"), (boolean)ProfileAssume.isFeatureEnabled(feature));
    }

    public static void assumeFeatureDisabled(Profile.Feature feature) {
        Assume.assumeTrue((String)("Ignoring test as feature " + feature.name() + " is disabled"), (!ProfileAssume.isFeatureEnabled(feature) ? 1 : 0) != 0);
    }

    public static void assumePreview() {
        ProfileAssume.updateProfile();
        Assume.assumeTrue((String)"Ignoring test as community/preview profile is not enabled", (!profile.equals("product") ? 1 : 0) != 0);
    }

    public static void assumePreviewDisabled() {
        ProfileAssume.updateProfile();
        Assume.assumeFalse((String)"Ignoring test as community/preview profile is enabled", (!profile.equals("product") ? 1 : 0) != 0);
    }

    public static void assumeCommunity() {
        ProfileAssume.updateProfile();
        Assume.assumeTrue((String)"Ignoring test as community profile is not enabled", (boolean)profile.equals("community"));
    }

    public static boolean isFeatureEnabled(Profile.Feature feature) {
        ProfileAssume.updateProfile();
        return !disabledFeatures.contains(feature.name());
    }
}

