/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.x509;

import com.google.common.base.Charsets;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.BlockingHandler;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.authentication.authenticators.x509.X509AuthenticatorConfigModel;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.PhantomJSBrowser;
import org.keycloak.testsuite.x509.AbstractX509AuthenticationTest;
import org.keycloak.testsuite.x509.OcspHandler;
import org.openqa.selenium.WebDriver;

public class X509OCSPResponderTest
extends AbstractX509AuthenticationTest {
    private static final String OCSP_RESPONDER_HOST = "localhost";
    private static final int OCSP_RESPONDER_PORT = 8888;
    private Undertow ocspResponder;
    @Drone
    @PhantomJSBrowser
    private WebDriver phantomJS;

    @Before
    public void replaceTheDefaultDriver() {
        this.replaceDefaultWebDriver(this.phantomJS);
    }

    @Test
    public void loginFailedOnOCSPResponderRevocationCheck() throws Exception {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setOCSPEnabled(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509OCSPResponderTest.newConfig("x509-directgrant-config", config.getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_request", (Object)response.getError());
        Assert.assertThat((Object)response.getErrorDescription(), (Matcher)Matchers.containsString((String)"Certificate's been revoked."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loginFailedOnOCSPResponderRevocationCheckWithoutCA() throws Exception {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setOCSPEnabled(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setOCSPResponder("http://localhost:8888/oscp").setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509OCSPResponderTest.newConfig("x509-directgrant-config", config.getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        String keyStorePath = Paths.get(System.getProperty("client.certificate.keystore"), new String[0]).getParent().resolve("client-ca.jks").toString();
        String keyStorePassword = System.getProperty("client.certificate.keystore.passphrase");
        String trustStorePath = System.getProperty("client.truststore");
        String trustStorePassword = System.getProperty("client.truststore.passphrase");
        Supplier previous = this.oauth.getHttpClient();
        try {
            this.oauth.clientId("resource-owner");
            this.oauth.httpClient(() -> OAuthClient.newCloseableHttpClientSSL((String)keyStorePath, (String)keyStorePassword, (String)trustStorePath, (String)trustStorePassword));
            OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
            Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatusCode());
            Assert.assertEquals((Object)"invalid_request", (Object)response.getError());
            Assert.assertThat((Object)response.getErrorDescription(), (Matcher)Matchers.containsString((String)"Responder's certificate not valid for signing OCSP responses"));
        }
        finally {
            this.oauth.httpClient(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loginClientCertSignedByIntermediateCA() throws Exception {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setOCSPEnabled(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setOCSPResponder("http://localhost:8888/oscp").setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509OCSPResponderTest.newConfig("x509-directgrant-config", config.getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        String keyStorePath = Paths.get(System.getProperty("client.certificate.keystore"), new String[0]).getParent().resolve("test-user-cert-intermediary-ca.jks").toString();
        String keyStorePassword = System.getProperty("client.certificate.keystore.passphrase");
        String trustStorePath = System.getProperty("client.truststore");
        String trustStorePassword = System.getProperty("client.truststore.passphrase");
        Supplier previous = this.oauth.getHttpClient();
        try {
            this.oauth.clientId("resource-owner");
            this.oauth.httpClient(() -> OAuthClient.newCloseableHttpClientSSL((String)keyStorePath, (String)keyStorePassword, (String)trustStorePath, (String)trustStorePassword));
            OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatusCode());
        }
        finally {
            this.oauth.httpClient(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loginOKOnOCSPResponderRevocationCheckWithoutCA() throws Exception {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setOCSPEnabled(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setOCSPResponder("http://localhost:8888/oscp").setOCSPResponderCertificate(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/client-auth-test/intermediate-ca.crt"), (Charset)Charsets.UTF_8).replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "")).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509OCSPResponderTest.newConfig("x509-directgrant-config", config.getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        String keyStorePath = Paths.get(System.getProperty("client.certificate.keystore"), new String[0]).getParent().resolve("client-ca.jks").toString();
        String keyStorePassword = System.getProperty("client.certificate.keystore.passphrase");
        String trustStorePath = System.getProperty("client.truststore");
        String trustStorePassword = System.getProperty("client.truststore.passphrase");
        Supplier previous = this.oauth.getHttpClient();
        try {
            this.oauth.clientId("resource-owner");
            this.oauth.httpClient(() -> OAuthClient.newCloseableHttpClientSSL((String)keyStorePath, (String)keyStorePassword, (String)trustStorePath, (String)trustStorePassword));
            OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatusCode());
        }
        finally {
            this.oauth.httpClient(previous);
        }
    }

    @Before
    public void startOCSPResponder() throws Exception {
        this.ocspResponder = Undertow.builder().addHttpListener(8888, OCSP_RESPONDER_HOST).setHandler((HttpHandler)new BlockingHandler((HttpHandler)new OcspHandler("/client-auth-test/intermediate-ca.crt", "/client-auth-test/intermediate-ca.key"))).build();
        this.ocspResponder.start();
    }

    @After
    public void stopOCSPResponder() {
        this.ocspResponder.stop();
    }
}

