/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.x509;

import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.authentication.authenticators.x509.X509AuthenticatorConfigModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.PhantomJSBrowser;
import org.keycloak.testsuite.x509.AbstractX509AuthenticationTest;
import org.openqa.selenium.WebDriver;

public class X509DirectGrantTest
extends AbstractX509AuthenticationTest {
    @Drone
    @PhantomJSBrowser
    private WebDriver phantomJS;

    @Before
    public void replaceTheDefaultDriver() {
        this.replaceDefaultWebDriver(this.phantomJS);
    }

    @Test
    public void loginFailedOnDuplicateUsers() throws Exception {
        AuthenticatorConfigRepresentation cfg = X509DirectGrantTest.newConfig("x509-directgrant-config", X509DirectGrantTest.createLoginIssuerDN_OU2CustomAttributeConfig().getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        UserRepresentation user = this.testRealm().users().get(this.userId2).toRepresentation();
        Assert.assertNotNull((Object)user);
        user.singleAttribute("x509_certificate_identity", "Red Hat");
        this.updateUser(user);
        user = this.testRealm().users().get(this.userId).toRepresentation();
        Assert.assertNotNull((Object)user);
        user.singleAttribute("x509_certificate_identity", "Red Hat");
        this.updateUser(user);
        this.events.clear();
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_request", (Object)response.getError());
        Assert.assertThat((Object)response.getErrorDescription(), (Matcher)Matchers.containsString((String)"X509 certificate authentication's failed."));
    }

    @Test
    public void loginFailedOnInvalidUser() throws Exception {
        AuthenticatorConfigRepresentation cfg = X509DirectGrantTest.newConfig("x509-directgrant-config", X509DirectGrantTest.createLoginIssuerDN_OU2CustomAttributeConfig().getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        UserRepresentation user = this.testRealm().users().get(this.userId2).toRepresentation();
        Assert.assertNotNull((Object)user);
        user.singleAttribute("x509_certificate_identity", "-");
        this.updateUser(user);
        this.events.clear();
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
        this.events.expectLogin().user((String)null).session((String)null).error("invalid_user_credentials").client("resource-owner").removeDetail("code_id").removeDetail("username").removeDetail("consent").removeDetail("redirect_uri").assertEvent();
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"Invalid user credentials", (Object)response.getErrorDescription());
    }

    @Test
    public void loginWithNonSupportedCertKeyUsage() throws Exception {
        AuthenticatorConfigRepresentation cfg = X509DirectGrantTest.newConfig("x509-directgrant-config", X509DirectGrantTest.createLoginSubjectEmailWithKeyUsage("dataEncipherment").getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_request", (Object)response.getError());
        Assert.assertThat((Object)response.getErrorDescription(), (Matcher)Matchers.containsString((String)"Key Usage bit 'dataEncipherment' is not set."));
        this.events.clear();
    }

    @Test
    public void loginWithNonSupportedCertExtendedKeyUsage() throws Exception {
        AuthenticatorConfigRepresentation cfg = X509DirectGrantTest.newConfig("x509-directgrant-config", X509DirectGrantTest.createLoginSubjectEmailWithExtendedKeyUsage("serverAuth").getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void loginWithNonMatchingRegex() throws Exception {
        X509AuthenticatorConfigModel config = X509DirectGrantTest.createLoginIssuerDN_OU2CustomAttributeConfig();
        config.setRegularExpression("INVALID=(.*?)(?:,|$)");
        AuthenticatorConfigRepresentation cfg = X509DirectGrantTest.newConfig("x509-directgrant-config", config.getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectLogin().user((String)null).session((String)null).error("invalid_user_credentials").client("resource-owner").removeDetail("code_id").removeDetail("consent").removeDetail("redirect_uri");
        this.addX509CertificateDetails(expectedEvent).assertEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loginFailedDisabledUser() throws Exception {
        this.setUserEnabled("test-user@localhost", false);
        try {
            AuthenticatorConfigRepresentation cfg = X509DirectGrantTest.newConfig("x509-directgrant-config", X509DirectGrantTest.createLoginSubjectEmail2UsernameOrEmailConfig().getConfig());
            String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
            Assert.assertNotNull((Object)cfgId);
            this.oauth.clientId("resource-owner");
            OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
            this.events.expectLogin().user(this.userId).session((String)null).error("user_disabled").client("resource-owner").detail("username", "test-user@localhost").removeDetail("code_id").removeDetail("consent").removeDetail("redirect_uri").assertEvent();
            Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatusCode());
            Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
            Assert.assertEquals((Object)"Account disabled", (Object)response.getErrorDescription());
        }
        finally {
            this.setUserEnabled("test-user@localhost", true);
        }
    }

    @Test
    public void loginCertificateRevoked() throws Exception {
        ContainerAssume.assumeNotAuthServerUndertow();
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setCRLEnabled(true).setCRLRelativePath("intermediate-ca.crl").setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509DirectGrantTest.newConfig("x509-directgrant-config", config.getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_request", (Object)response.getError());
        Assert.assertThat((Object)response.getErrorDescription(), (Matcher)Matchers.containsString((String)"Certificate has been revoked, certificate's subject:"));
    }

    @Test
    public void loginCertificateNotExpired() throws Exception {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setCertValidationEnabled(true).setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509DirectGrantTest.newConfig("x509-directgrant-config", config.getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void loginCertificateExpired() throws Exception {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setCertValidationEnabled(true).setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509DirectGrantTest.newConfig("x509-directgrant-config", config.getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.setTimeOffset(1576800000);
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
        this.setTimeOffset(0);
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_request", (Object)response.getError());
        Assert.assertThat((Object)response.getErrorDescription(), (Matcher)Matchers.containsString((String)"has expired on:"));
    }

    private void loginForceTemporaryAccountLock() throws Exception {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.ISSUERDN).setRegularExpression("OU=(.*?)(?:,|$)").setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USER_ATTRIBUTE).setCustomAttributeName("x509_certificate_identity");
        AuthenticatorConfigRepresentation cfg = X509DirectGrantTest.newConfig("x509-directgrant-config", config.getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        UserRepresentation user = this.testRealm().users().get(this.userId).toRepresentation();
        Assert.assertNotNull((Object)user);
        user.singleAttribute("x509_certificate_identity", "-");
        this.updateUser(user);
        this.events.clear();
        this.oauth.clientId("resource-owner");
        this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
        this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
        this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
        this.events.clear();
    }

    @Test
    @Ignore
    public void loginFailedTemporarilyDisabledUser() throws Exception {
        this.loginForceTemporaryAccountLock();
        AuthenticatorConfigRepresentation cfg = X509DirectGrantTest.newConfig("x509-directgrant-config", X509DirectGrantTest.createLoginSubjectEmail2UsernameOrEmailConfig().getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
        this.events.expectLogin().user(this.userId).session((String)null).error("user_temporarily_disabled").detail("username", "test-user@localhost").removeDetail("code_id").removeDetail("consent").removeDetail("redirect_uri").assertEvent();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"Account temporarily disabled", (Object)response.getErrorDescription());
    }

    private void doResourceOwnerCredentialsLogin(String clientId, String clientSecret, String login, String password) throws Exception {
        this.oauth.clientId(clientId);
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest(clientSecret, "", "", null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.parseRefreshToken(response.getRefreshToken());
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectLogin().client(clientId).user(this.userId).session(accessToken.getSessionState()).detail("grant_type", "password").detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", login).removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent");
        this.addX509CertificateDetails(expectedEvent).assertEvent();
    }

    @Test
    public void loginResourceOwnerCredentialsSuccess() throws Exception {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509DirectGrantTest.newConfig("x509-directgrant-config", config.getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.doResourceOwnerCredentialsLogin("resource-owner", "secret", "test-user@localhost", "");
    }
}

