/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.x509;

import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.authentication.authenticators.x509.X509AuthenticatorConfigModel;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.PhantomJSBrowser;
import org.keycloak.testsuite.x509.AbstractX509AuthenticationTest;
import org.openqa.selenium.WebDriver;

public class X509BrowserLoginTest
extends AbstractX509AuthenticationTest {
    @Drone
    @PhantomJSBrowser
    private WebDriver phantomJS;

    @Before
    public void replaceTheDefaultDriver() {
        this.replaceDefaultWebDriver(this.phantomJS);
    }

    @Test
    public void loginAsUserFromCertSubjectEmail() throws Exception {
        this.x509BrowserLogin(X509BrowserLoginTest.createLoginSubjectEmail2UsernameOrEmailConfig(), this.userId, "test-user@localhost", "test-user@localhost");
    }

    @Test
    public void loginWithNonMatchingRegex() throws Exception {
        X509AuthenticatorConfigModel config = X509BrowserLoginTest.createLoginIssuerDN_OU2CustomAttributeConfig();
        config.setRegularExpression("INVALID=(.*?)(?:,|$)");
        AuthenticatorConfigRepresentation cfg = X509BrowserLoginTest.newConfig("x509-browser-config", config.getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.loginConfirmationPage.open();
        this.events.expectLogin().user((String)null).session((String)null).error("invalid_user_credentials").removeDetail("consent").removeDetail("redirect_uri").assertEvent();
    }

    @Test
    public void loginWithNonSupportedCertKeyUsage() throws Exception {
        AuthenticatorConfigRepresentation cfg = X509BrowserLoginTest.newConfig("x509-browser-config", X509BrowserLoginTest.createLoginSubjectEmailWithKeyUsage("dataEncipherment").getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.loginConfirmationPage.open();
        Assert.assertThat((Object)this.loginPage.getError(), (Matcher)Matchers.containsString((String)"Certificate validation's failed.\nKey Usage bit 'dataEncipherment' is not set."));
    }

    @Test
    public void loginWithNonSupportedCertExtendedKeyUsage() throws Exception {
        this.x509BrowserLogin(X509BrowserLoginTest.createLoginSubjectEmailWithExtendedKeyUsage("serverAuth"), this.userId, "test-user@localhost", "test-user@localhost");
    }

    @Test
    public void loginWithRevalidateCertEnabledCertIsTrusted() throws Exception {
        this.x509BrowserLogin(X509BrowserLoginTest.createLoginSubjectEmailWithRevalidateCert(true), this.userId, "test-user@localhost", "test-user@localhost");
    }

    @Test
    public void loginIgnoreX509IdentityContinueToFormLogin() throws Exception {
        AuthenticatorConfigRepresentation cfg = X509BrowserLoginTest.newConfig("x509-browser-config", X509BrowserLoginTest.createLoginSubjectEmail2UsernameOrEmailConfig().getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.loginConfirmationPage.open();
        Assert.assertTrue((boolean)this.loginConfirmationPage.getSubjectDistinguishedNameText().startsWith("EMAILADDRESS=test-user@localhost"));
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.loginConfirmationPage.getUsernameText());
        this.loginConfirmationPage.ignore();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(this.userId).detail("username", "test-user@localhost").removeDetail("redirect_uri").assertEvent();
    }

    @Test
    public void loginAsUserFromCertSubjectCN() {
        this.x509BrowserLogin(X509BrowserLoginTest.createLoginSubjectCN2UsernameOrEmailConfig(), this.userId, "test-user@localhost", "test-user@localhost");
    }

    @Test
    public void loginAsUserFromCertSerialnumberAndIssuerDNMappedToUserAttribute() {
        UserRepresentation user = this.testRealm().users().get(this.userId2).toRepresentation();
        Assert.assertNotNull((Object)user);
        user.singleAttribute("x509_certificate_serialnumber", "4105");
        user.singleAttribute("x509_issuer_dn", "EMAILADDRESS=contact@keycloak.org, CN=Keycloak Intermediate CA, OU=Keycloak, O=Red Hat, ST=MA, C=US");
        this.updateUser(user);
        this.events.clear();
        this.x509BrowserLogin(X509BrowserLoginTest.createLoginWithSpecifiedSourceTypeToCustomAttributeConfig(X509AuthenticatorConfigModel.MappingSourceType.SERIALNUMBER_ISSUERDN, "x509_certificate_serialnumber##x509_issuer_dn"), this.userId2, "keycloak", "4105##EMAILADDRESS=contact@keycloak.org, CN=Keycloak Intermediate CA, OU=Keycloak, O=Red Hat, ST=MA, C=US");
    }

    @Test
    public void loginAsUserFromHexCertSerialnumberAndIssuerDNMappedToUserAttribute() {
        UserRepresentation user = this.testRealm().users().get(this.userId2).toRepresentation();
        Assert.assertNotNull((Object)user);
        user.singleAttribute("x509_certificate_serialnumber", "1009");
        user.singleAttribute("x509_issuer_dn", "EMAILADDRESS=contact@keycloak.org, CN=Keycloak Intermediate CA, OU=Keycloak, O=Red Hat, ST=MA, C=US");
        this.updateUser(user);
        this.events.clear();
        X509AuthenticatorConfigModel config = X509BrowserLoginTest.createLoginWithSpecifiedSourceTypeToCustomAttributeConfig(X509AuthenticatorConfigModel.MappingSourceType.SERIALNUMBER_ISSUERDN, "x509_certificate_serialnumber##x509_issuer_dn");
        config.setSerialnumberHex(true);
        this.x509BrowserLogin(config, this.userId2, "keycloak", "1009##EMAILADDRESS=contact@keycloak.org, CN=Keycloak Intermediate CA, OU=Keycloak, O=Red Hat, ST=MA, C=US");
    }

    @Test
    public void loginAsUserFromCertIssuerDNMappedToUserAttribute() {
        UserRepresentation user = this.testRealm().users().get(this.userId2).toRepresentation();
        Assert.assertNotNull((Object)user);
        user.singleAttribute("x509_certificate_identity", "Red Hat");
        this.updateUser(user);
        this.events.clear();
        this.x509BrowserLogin(X509BrowserLoginTest.createLoginIssuerDN_OU2CustomAttributeConfig(), this.userId2, "keycloak", "Red Hat");
    }

    @Test
    public void loginAsUserFromCertSHA256MappedToUserAttribute() {
        UserRepresentation user = this.testRealm().users().get(this.userId2).toRepresentation();
        Assert.assertNotNull((Object)user);
        user.singleAttribute("x509_cert_sha256thumbprint", "71237a14c118a90cc8406f14d039ed3431c9065f68e535293ee919d4c33b5e15");
        this.updateUser(user);
        this.events.clear();
        this.x509BrowserLogin(X509BrowserLoginTest.createLoginWithSpecifiedSourceTypeToCustomAttributeConfig(X509AuthenticatorConfigModel.MappingSourceType.SHA256_THUMBPRINT, "x509_cert_sha256thumbprint"), this.userId2, "keycloak", "71237a14c118a90cc8406f14d039ed3431c9065f68e535293ee919d4c33b5e15");
    }

    @Test
    public void loginAsUserFromCertSerialNumberMappedToUserAttribute() {
        UserRepresentation user = this.testRealm().users().get(this.userId2).toRepresentation();
        Assert.assertNotNull((Object)user);
        user.singleAttribute("x509_serial_number", "4105");
        this.updateUser(user);
        this.events.clear();
        this.x509BrowserLogin(X509BrowserLoginTest.createLoginWithSpecifiedSourceTypeToCustomAttributeConfig(X509AuthenticatorConfigModel.MappingSourceType.SERIALNUMBER, "x509_serial_number"), this.userId2, "keycloak", "4105");
    }

    @Test
    public void loginAsUserFromHexCertSerialNumberMappedToUserAttribute() {
        UserRepresentation user = this.testRealm().users().get(this.userId2).toRepresentation();
        Assert.assertNotNull((Object)user);
        user.singleAttribute("x509_serial_number", "1009");
        this.updateUser(user);
        this.events.clear();
        X509AuthenticatorConfigModel config = X509BrowserLoginTest.createLoginWithSpecifiedSourceTypeToCustomAttributeConfig(X509AuthenticatorConfigModel.MappingSourceType.SERIALNUMBER, "x509_serial_number");
        config.setSerialnumberHex(true);
        this.x509BrowserLogin(config, this.userId2, "keycloak", "1009");
    }

    @Test
    public void loginDuplicateUsersNotAllowed() {
        AuthenticatorConfigRepresentation cfg = X509BrowserLoginTest.newConfig("x509-browser-config", X509BrowserLoginTest.createLoginIssuerDN_OU2CustomAttributeConfig().getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        UserRepresentation user = this.testRealm().users().get(this.userId2).toRepresentation();
        Assert.assertNotNull((Object)user);
        user.singleAttribute("x509_certificate_identity", "Red Hat");
        this.updateUser(user);
        user = this.testRealm().users().get(this.userId).toRepresentation();
        Assert.assertNotNull((Object)user);
        user.singleAttribute("x509_certificate_identity", "Red Hat");
        this.updateUser(user);
        this.events.clear();
        this.loginPage.open();
        Assert.assertThat((Object)this.loginPage.getError(), (Matcher)Matchers.containsString((String)"X509 certificate authentication's failed."));
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(this.userId).detail("username", "test-user@localhost").removeDetail("redirect_uri").assertEvent();
    }

    @Test
    public void loginAttemptedNoConfig() {
        this.loginConfirmationPage.open();
        this.loginPage.assertCurrent();
        Assert.assertThat((Object)this.loginPage.getInfoMessage(), (Matcher)Matchers.containsString((String)"X509 client authentication has not been configured yet"));
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(this.userId).detail("username", "test-user@localhost").removeDetail("redirect_uri").assertEvent();
    }

    @Test
    public void loginWithX509CertCustomAttributeUserNotFound() {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN).setRegularExpression("O=(.*?)(?:,|$)").setCustomAttributeName("x509_certificate_identity").setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USER_ATTRIBUTE);
        AuthenticatorConfigRepresentation cfg = X509BrowserLoginTest.newConfig("x509-browser-config", config.getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.loginConfirmationPage.open();
        this.loginPage.assertCurrent();
        Assert.assertNotNull((Object)this.loginPage.getError());
        Assert.assertThat((Object)this.loginPage.getError(), (Matcher)Matchers.containsString((String)"X509 certificate authentication's failed."));
        this.events.expectLogin().user((String)null).session((String)null).error("user_not_found").detail("username", "Red Hat").removeDetail("consent").removeDetail("redirect_uri").assertEvent();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(this.userId).detail("username", "test-user@localhost").removeDetail("redirect_uri").assertEvent();
    }

    @Test
    public void loginWithX509CertCustomAttributeSuccess() {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN).setRegularExpression("O=(.*?)(?:,|$)").setCustomAttributeName("x509_certificate_identity").setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USER_ATTRIBUTE);
        AuthenticatorConfigRepresentation cfg = X509BrowserLoginTest.newConfig("x509-browser-config", config.getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        UserRepresentation user = this.findUser("test-user@localhost");
        Assert.assertNotNull((Object)user);
        user.singleAttribute("x509_certificate_identity", "Red Hat");
        this.updateUser(user);
        this.events.clear();
        this.loginConfirmationPage.open();
        Assert.assertTrue((boolean)this.loginConfirmationPage.getSubjectDistinguishedNameText().startsWith("EMAILADDRESS=test-user@localhost"));
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.loginConfirmationPage.getUsernameText());
        this.loginConfirmationPage.confirm();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
    }

    @Test
    public void loginWithX509CertBadUserOrNotFound() {
        AuthenticatorConfigRepresentation cfg = X509BrowserLoginTest.newConfig("x509-browser-config", X509BrowserLoginTest.createLoginSubjectEmail2UsernameOrEmailConfig().getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        UserRepresentation user = this.findUser("test-user@localhost");
        Assert.assertNotNull((Object)user);
        Response response = this.testRealm().users().delete(this.userId);
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response.close();
        this.loginConfirmationPage.open();
        this.loginPage.assertCurrent();
        Assert.assertNotNull((Object)this.loginPage.getError());
        Assert.assertThat((Object)this.loginPage.getError(), (Matcher)Matchers.containsString((String)"X509 certificate authentication's failed."));
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectLogin().user((String)null).session((String)null).error("user_not_found").detail("username", "test-user@localhost").removeDetail("consent").removeDetail("redirect_uri");
        this.addX509CertificateDetails(expectedEvent).assertEvent();
        this.loginPage.login("test-user@localhost", "password");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.loginPage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.loginPage.getPassword());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
    }

    @Test
    public void loginValidCertificateDisabledUser() {
        this.setUserEnabled("test-user@localhost", false);
        try {
            AuthenticatorConfigRepresentation cfg = X509BrowserLoginTest.newConfig("x509-browser-config", X509BrowserLoginTest.createLoginSubjectEmail2UsernameOrEmailConfig().getConfig());
            String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
            Assert.assertNotNull((Object)cfgId);
            this.loginConfirmationPage.open();
            this.loginPage.assertCurrent();
            Assert.assertNotNull((Object)this.loginPage.getError());
            Assert.assertThat((Object)this.loginPage.getError(), (Matcher)Matchers.containsString((String)"X509 certificate authentication's failed.\nUser is disabled"));
            this.events.expectLogin().user(this.userId).session((String)null).error("user_disabled").detail("username", "test-user@localhost").removeDetail("consent").removeDetail("redirect_uri").assertEvent();
            this.loginPage.login("test-user@localhost", "password");
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"test-user@localhost", (Object)this.loginPage.getUsername());
            Assert.assertEquals((Object)"", (Object)this.loginPage.getPassword());
            Assert.assertEquals((Object)"Account is disabled, contact your administrator.", (Object)this.loginPage.getError());
            this.events.expectLogin().user(this.userId).session((String)null).error("user_disabled").detail("username", "test-user@localhost").removeDetail("consent").removeDetail("redirect_uri").assertEvent();
        }
        finally {
            this.setUserEnabled("test-user@localhost", true);
        }
    }

    @Test
    public void loginNoIdentityConfirmationPage() {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setConfirmationPageAllowed(false).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509BrowserLoginTest.newConfig("x509-browser-config", config.getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectLogin().user(this.userId).detail("username", "test-user@localhost").removeDetail("redirect_uri");
        this.addX509CertificateDetails(expectedEvent).assertEvent();
    }

    @Test
    public void loginWithCertificateAddedLater() throws Exception {
        this.loginConfirmationPage.open();
        this.loginPage.assertCurrent();
        Assert.assertThat((Object)this.loginPage.getInfoMessage(), (Matcher)Matchers.containsString((String)"X509 client authentication has not been configured yet"));
        this.loginPage.assertCurrent();
        this.loginAsUserFromCertSubjectEmail();
    }

    @Test
    public void changeLocaleOnX509InfoPage() {
        ProfileAssume.assumeCommunity();
        AuthenticatorConfigRepresentation cfg = X509BrowserLoginTest.newConfig("x509-browser-config", X509BrowserLoginTest.createLoginSubjectEmail2UsernameOrEmailConfig().getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.log.debug((Object)"Open confirm page");
        this.loginConfirmationPage.open();
        this.log.debug((Object)"check if on confirm page");
        Assert.assertThat((Object)this.loginConfirmationPage.getSubjectDistinguishedNameText(), (Matcher)Matchers.startsWith((String)"EMAILADDRESS=test-user@localhost"));
        this.log.debug((Object)"check if locale is EN");
        Assert.assertThat((Object)this.loginConfirmationPage.getLanguageDropdownText(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"English")));
        this.log.debug((Object)"change locale to DE");
        this.loginConfirmationPage.openLanguage("Deutsch");
        this.log.debug((Object)"check if locale is DE");
        Assert.assertThat((Object)this.loginConfirmationPage.getLanguageDropdownText(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Deutsch")));
        Assert.assertThat((Object)DroneUtils.getCurrentDriver().getPageSource(), (Matcher)Matchers.containsString((String)"X509 Client Zertifikat:"));
        this.log.debug((Object)"confirm cert");
        this.loginConfirmationPage.confirm();
        this.log.debug((Object)"check if logged in");
        Assert.assertThat((Object)this.appPage.getRequestType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)AppPage.RequestType.AUTH_RESPONSE)));
    }
}

