/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.x509;

import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.util.PhantomJSBrowser;
import org.keycloak.testsuite.x509.AbstractX509AuthenticationTest;
import org.openqa.selenium.WebDriver;

public class X509BrowserLoginSubjectDnTest
extends AbstractX509AuthenticationTest {
    @Drone
    @PhantomJSBrowser
    private WebDriver phantomJS;

    @Before
    public void replaceTheDefaultDriver() {
        this.replaceDefaultWebDriver(this.phantomJS);
    }

    @BeforeClass
    public static void checkAssumption() {
        try {
            CertificateFactory.getInstance("X.509", "SUN");
        }
        catch (NoSuchProviderException | CertificateException e) {
            Assume.assumeNoException((String)"Test assumes the SUN security provider", (Throwable)e);
        }
    }

    @BeforeClass
    public static void onBeforeTestClass() {
        X509BrowserLoginSubjectDnTest.configurePhantomJS("/ca.crt", "/certs/clients/test-user-san@localhost.cert.pem", "/certs/clients/test-user@localhost.key.pem", "password");
    }

    private String setup(boolean canonicalDnEnabled) throws Exception {
        String subjectDn = canonicalDnEnabled ? "1.2.840.113549.1.9.1=#1613746573742d75736572406c6f63616c686f7374,cn=test-user,ou=keycloak,o=red hat,l=boston,st=ma,c=us" : "EMAILADDRESS=test-user@localhost, CN=test-user, OU=Keycloak, O=Red Hat, L=Boston, ST=MA, C=US";
        UserRepresentation user = this.findUser("test-user@localhost");
        user.singleAttribute("x509_certificate_identity", subjectDn);
        this.updateUser(user);
        return subjectDn;
    }

    @Test
    public void loginAsUserFromCertSubjectDnCanonical() throws Exception {
        String subjectDn = this.setup(true);
        this.x509BrowserLogin(X509BrowserLoginSubjectDnTest.createLoginSubjectDNToCustomAttributeConfig(true), this.userId, "test-user@localhost", subjectDn);
    }

    @Test
    public void loginAsUserFromCertSubjectDnNonCanonical() throws Exception {
        String subjectDn = this.setup(false);
        this.x509BrowserLogin(X509BrowserLoginSubjectDnTest.createLoginSubjectDNToCustomAttributeConfig(false), this.userId, "test-user@localhost", subjectDn);
    }
}

