/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.welcomepage;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.RestartContainer;
import org.keycloak.testsuite.auth.page.WelcomePage;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.PhantomJSBrowser;
import org.keycloak.testsuite.util.URLUtils;
import org.openqa.selenium.WebDriver;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@RestartContainer(initializeDatabase=true, intializeDatabaseWait=0L, withoutKeycloakAddUserFile=true)
public class WelcomePageTest
extends AbstractKeycloakTest {
    @Drone
    @PhantomJSBrowser
    private WebDriver phantomJS;
    @Page
    @PhantomJSBrowser
    protected OIDCLogin loginPage;
    @Page
    @PhantomJSBrowser
    protected WelcomePage welcomePage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }

    @BeforeClass
    public static void enabled() {
        ContainerAssume.assumeNotAuthServerRemote();
    }

    @Override
    @Before
    public void beforeAbstractKeycloakTest() throws Exception {
        Assume.assumeThat((String)"Test skipped", (Object)this.suiteContext.getAuthServerInfo().isJBossBased(), (Matcher)Matchers.is((Object)true));
        DroneUtils.replaceDefaultWebDriver((Object)this, (WebDriver)this.phantomJS);
        this.setDefaultPageUriParameters();
    }

    @Override
    @After
    public void afterAbstractKeycloakTest() {
    }

    private String getFloatingIpAddress() throws Exception {
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface ni : Collections.list(netInterfaces)) {
            Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
            for (InetAddress a : Collections.list(inetAddresses)) {
                if (a.isLoopbackAddress() || !a.isSiteLocalAddress()) continue;
                return a.getHostAddress();
            }
        }
        return null;
    }

    private URL getPublicServerUrl() throws Exception {
        String floatingIp = this.getFloatingIpAddress();
        if (floatingIp == null) {
            throw new RuntimeException("Could not determine floating IP address.");
        }
        return new URL("http", floatingIp, this.welcomePage.getInjectedUrl().getPort(), "");
    }

    @Test
    public void test_1_LocalAccessNoAdmin() throws Exception {
        this.welcomePage.navigateTo();
        Assert.assertFalse((String)"Welcome page did not ask to create a new admin user.", (boolean)this.welcomePage.isPasswordSet());
    }

    @Test
    public void test_2_RemoteAccessNoAdmin() throws Exception {
        URLUtils.navigateToUri((String)this.getPublicServerUrl().toString());
        Assert.assertFalse((String)"Welcome page did not ask to create a new admin user.", (boolean)this.welcomePage.isPasswordSet());
    }

    @Test
    public void test_3_LocalAccessWithAdmin() throws Exception {
        this.welcomePage.navigateTo();
        this.welcomePage.setPassword("admin", "admin");
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("User created"));
        this.welcomePage.navigateTo();
        Assert.assertTrue((String)"Welcome page asked to set admin password.", (boolean)this.welcomePage.isPasswordSet());
    }

    @Test
    public void test_4_RemoteAccessWithAdmin() throws Exception {
        URLUtils.navigateToUri((String)this.getPublicServerUrl().toString());
        Assert.assertTrue((String)"Welcome page asked to set admin password.", (boolean)this.welcomePage.isPasswordSet());
    }

    @Test
    public void test_5_AccessCreatedAdminAccount() throws Exception {
        this.welcomePage.navigateToAdminConsole();
        this.loginPage.form().login("admin", "admin");
        Assert.assertFalse((String)"Login with 'admin:admin' failed", (boolean)this.driver.getPageSource().contains("Invalid username or password."));
    }

    @Test
    public void test_6_CheckProductNameOnWelcomePage() {
        this.welcomePage.navigateTo();
        String actualMessage = this.welcomePage.getWelcomeMessage();
        String expectedMessage = this.suiteContext.getAuthServerInfo().isEAP() ? "Red Hat Single Sign-On" : "Keycloak";
        Assert.assertEquals((Object)("Welcome to " + expectedMessage), (Object)actualMessage);
    }
}

