/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.vault;

import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableVault;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.keycloak.vault.VaultStringSecret;
import org.keycloak.vault.VaultTranscriber;

@EnableVault
@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class KeycloakVaultTest
extends AbstractKeycloakTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/testrealm.json"));
    }

    @Test
    public void testKeycloakVault() throws Exception {
        this.testingClient.server().run((RunOnServer)new KeycloakVaultServerTest("${vault.smtp_key}", "secure_master_smtp_secret"));
        this.testingClient.server("test").run((RunOnServer)new KeycloakVaultServerTest("${vault.smtp_key}", "secure_test_smtp_secret"));
    }

    static class KeycloakVaultServerTest
    implements RunOnServer {
        private String testKey;
        private String expectedSecret;

        public KeycloakVaultServerTest(String key, String expectedSecret) {
            this.testKey = key;
            this.expectedSecret = expectedSecret;
        }

        public void run(KeycloakSession session) {
            Optional optional;
            VaultTranscriber transcriber = session.vault();
            Assert.assertNotNull((Object)transcriber);
            try (VaultStringSecret secret = transcriber.getStringSecret(this.testKey);){
                Optional optional2 = secret.get();
                Assert.assertTrue((boolean)optional2.isPresent());
                String secretString = (String)optional2.get();
                Assert.assertEquals((Object)this.expectedSecret, (Object)secretString);
            }
            String invalidEntry = "${vault.invalid_entry}";
            try (VaultStringSecret secret = transcriber.getStringSecret(invalidEntry);){
                optional = secret.get();
                Assert.assertFalse((boolean)optional.isPresent());
            }
            secret = transcriber.getStringSecret("mysecret");
            var5_5 = null;
            try {
                optional = secret.get();
                Assert.assertTrue((boolean)optional.isPresent());
                String secretString = (String)optional.get();
                Assert.assertEquals((Object)"mysecret", (Object)secretString);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (secret != null) {
                    if (var5_5 != null) {
                        try {
                            secret.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        secret.close();
                    }
                }
            }
        }
    }
}

