/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;

public class UserManager {
    private static RealmResource realm;

    private UserManager() {
    }

    public static UserManager realm(RealmResource realm) {
        UserManager.realm = realm;
        return new UserManager();
    }

    public UserManagerBuilder username(String username) {
        return new UserManagerBuilder(ApiUtil.findUserByUsernameId((RealmResource)realm, (String)username));
    }

    public UserManagerBuilder user(UserResource user) {
        return new UserManagerBuilder(user);
    }

    public class UserManagerBuilder {
        private final UserResource userResource;

        public UserManagerBuilder(UserResource userResource) {
            this.userResource = userResource;
        }

        public void removeRequiredAction(String action) {
            UserRepresentation user = this.initializeRequiredActions();
            user.getRequiredActions().remove(action);
            this.userResource.update(user);
        }

        public void addRequiredAction(String ... actions) {
            UserRepresentation user = this.initializeRequiredActions();
            user.setRequiredActions(Arrays.asList(actions));
            this.userResource.update(user);
        }

        public void assignRoles(String ... roles) {
            UserRepresentation user = this.userResource.toRepresentation();
            if (user != null && user.getRealmRoles() == null) {
                user.setRealmRoles(new ArrayList());
            }
            user.setRealmRoles(Arrays.asList(roles));
            this.userResource.update(user);
        }

        public void enabled(Boolean enabled) {
            UserRepresentation user = this.userResource.toRepresentation();
            user.setEnabled(enabled);
            this.userResource.update(user);
        }

        private UserRepresentation initializeRequiredActions() {
            UserRepresentation user = this.userResource.toRepresentation();
            if (user != null && user.getRequiredActions() == null) {
                user.setRequiredActions(new ArrayList());
            }
            return user;
        }
    }
}

