/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.credential.OTPCredentialModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class UserBuilder {
    private final UserRepresentation rep;

    public static UserBuilder create() {
        UserRepresentation rep = new UserRepresentation();
        rep.setEnabled(Boolean.TRUE);
        return new UserBuilder(rep);
    }

    public static UserBuilder edit(UserRepresentation rep) {
        return new UserBuilder(rep);
    }

    private UserBuilder(UserRepresentation rep) {
        this.rep = rep;
    }

    public UserBuilder id(String id) {
        this.rep.setId(id);
        return this;
    }

    public UserBuilder username(String username) {
        this.rep.setUsername(username);
        return this;
    }

    public UserBuilder firstName(String firstName) {
        this.rep.setFirstName(firstName);
        return this;
    }

    public UserBuilder lastName(String lastName) {
        this.rep.setLastName(lastName);
        return this;
    }

    public UserBuilder addPassword(String password) {
        if (this.rep.getCredentials() == null) {
            this.rep.setCredentials(new LinkedList());
        }
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(password);
        this.rep.getCredentials().add(credential);
        return this;
    }

    public UserBuilder addAttribute(String name, String ... values) {
        if (this.rep.getAttributes() == null) {
            this.rep.setAttributes(new HashMap());
        }
        this.rep.getAttributes().put(name, Arrays.asList(values));
        return this;
    }

    public UserBuilder password(String password) {
        this.rep.setCredentials(null);
        return this.addPassword(password);
    }

    public UserBuilder email(String email) {
        this.rep.setEmail(email);
        return this;
    }

    public UserBuilder emailVerified(boolean emailVerified) {
        this.rep.setEmailVerified(Boolean.valueOf(emailVerified));
        return this;
    }

    public UserBuilder enabled(boolean enabled) {
        this.rep.setEnabled(Boolean.valueOf(enabled));
        return this;
    }

    public UserBuilder addRoles(String ... roles) {
        if (this.rep.getRealmRoles() == null) {
            this.rep.setRealmRoles(new ArrayList());
        }
        this.rep.getRealmRoles().addAll(Arrays.asList(roles));
        return this;
    }

    public UserBuilder role(String client, String role) {
        if (this.rep.getClientRoles() == null) {
            this.rep.setClientRoles(new HashMap());
        }
        if (this.rep.getClientRoles().get(client) == null) {
            this.rep.getClientRoles().put(client, new LinkedList());
        }
        ((List)this.rep.getClientRoles().get(client)).add(role);
        return this;
    }

    public UserBuilder requiredAction(String requiredAction) {
        if (this.rep.getRequiredActions() == null) {
            this.rep.setRequiredActions(new LinkedList());
        }
        this.rep.getRequiredActions().add(requiredAction);
        return this;
    }

    public UserBuilder serviceAccountId(String serviceAccountId) {
        this.rep.setServiceAccountClientId(serviceAccountId);
        return this;
    }

    public UserBuilder secret(CredentialRepresentation credential) {
        if (this.rep.getCredentials() == null) {
            this.rep.setCredentials(new LinkedList());
        }
        this.rep.getCredentials().add(credential);
        this.rep.setTotp(Boolean.valueOf(true));
        return this;
    }

    public UserBuilder totpSecret(String totpSecret) {
        CredentialRepresentation credential = ModelToRepresentation.toRepresentation((CredentialModel)OTPCredentialModel.createTOTP((String)totpSecret, (int)6, (int)30, (String)"HmacSHA1"));
        return this.secret(credential);
    }

    public UserBuilder hotpSecret(String hotpSecret) {
        CredentialRepresentation credential = ModelToRepresentation.toRepresentation((CredentialModel)OTPCredentialModel.createHOTP((String)hotpSecret, (int)6, (int)0, (String)"HmacSHA1"));
        return this.secret(credential);
    }

    public UserBuilder otpEnabled() {
        this.rep.setTotp(Boolean.TRUE);
        return this;
    }

    public UserBuilder addGroups(String ... group) {
        if (this.rep.getGroups() == null) {
            this.rep.setGroups(new ArrayList());
        }
        this.rep.getGroups().addAll(Arrays.asList(group));
        return this;
    }

    public UserBuilder federatedLink(String identityProvider, String federatedUserId) {
        if (this.rep.getFederatedIdentities() == null) {
            this.rep.setFederatedIdentities(new LinkedList());
        }
        FederatedIdentityRepresentation federatedIdentity = new FederatedIdentityRepresentation();
        federatedIdentity.setUserId(federatedUserId);
        federatedIdentity.setUserName(this.rep.getUsername());
        federatedIdentity.setIdentityProvider(identityProvider);
        this.rep.getFederatedIdentities().add(federatedIdentity);
        return this;
    }

    public UserRepresentation build() {
        return this.rep;
    }
}

