/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.junit.Assert;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.URLUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class URLAssert {
    public static void assertCurrentUrlEquals(AbstractPage page, WebDriver driver) {
        URLAssert.assertCurrentUrlEquals(page.toString(), driver);
    }

    public static void assertCurrentUrlEquals(String url, WebDriver driver) {
        DroneUtils.addWebDriver((WebDriver)driver);
        URLAssert.assertCurrentUrlEquals(url);
        DroneUtils.removeWebDriver();
    }

    public static void assertCurrentUrlEquals(AbstractPage page) {
        URLAssert.assertCurrentUrlEquals(page.toString());
    }

    public static void assertCurrentUrlEquals(URI url) {
        URLAssert.assertCurrentUrlEquals(url.toASCIIString());
    }

    public static void assertCurrentUrlEquals(String url) {
        Assert.assertTrue((String)("Expected URL: " + url + " ; actual: " + DroneUtils.getCurrentDriver().getCurrentUrl()), (boolean)URLUtils.currentUrlEquals((String)url));
    }

    public static void assertCurrentUrlStartsWith(AbstractPage page, WebDriver driver) {
        URLAssert.assertCurrentUrlStartsWith(page.toString(), driver);
    }

    public static void assertCurrentUrlStartsWith(String url, WebDriver driver) {
        DroneUtils.addWebDriver((WebDriver)driver);
        URLAssert.assertCurrentUrlStartsWith(url);
        DroneUtils.removeWebDriver();
    }

    public static void assertCurrentUrlStartsWith(AbstractPage page) {
        URLAssert.assertCurrentUrlStartsWith(page.toString());
    }

    public static void assertCurrentUrlStartsWith(String url) {
        Assert.assertTrue((String)("URL expected to begin with: " + ServerURLs.removeDefaultPorts((String)url) + " ; actual URL: " + DroneUtils.getCurrentDriver().getCurrentUrl()), (boolean)URLUtils.currentUrlStartsWith((String)ServerURLs.removeDefaultPorts((String)url)));
    }

    public static void waitUntilUrlStartsWith(String url, int timeOutInSeconds) {
        new WebDriverWait(DroneUtils.getCurrentDriver(), (long)timeOutInSeconds).until((Function)ExpectedConditions.urlMatches((String)("^" + url)));
    }

    public static void assertCurrentUrlDoesntStartWith(AbstractPage page, WebDriver driver) {
        URLAssert.assertCurrentUrlDoesntStartWith(page.toString(), driver);
    }

    public static void assertCurrentUrlDoesntStartWith(String url, WebDriver driver) {
        DroneUtils.addWebDriver((WebDriver)driver);
        URLAssert.assertCurrentUrlDoesntStartWith(url);
        DroneUtils.removeWebDriver();
    }

    public static void assertCurrentUrlDoesntStartWith(AbstractPage page) {
        URLAssert.assertCurrentUrlDoesntStartWith(page.toString());
    }

    public static void assertCurrentUrlDoesntStartWith(String url) {
        Assert.assertTrue((String)("URL expected NOT to begin with: " + url + " ; actual URL: " + DroneUtils.getCurrentDriver().getCurrentUrl()), (boolean)URLUtils.currentUrlDoesntStartWith((String)url));
    }

    public static void assertCurrentUrlStartsWithLoginUrlOf(PageWithLoginUrl page, WebDriver driver) {
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf(page.getOIDCLoginUrl().toString(), driver);
    }

    public static void assertCurrentUrlStartsWithLoginUrlOf(String url, WebDriver driver) {
        DroneUtils.addWebDriver((WebDriver)driver);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf(url);
        DroneUtils.removeWebDriver();
    }

    public static void assertCurrentUrlStartsWithLoginUrlOf(PageWithLoginUrl page) {
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf(page.getOIDCLoginUrl().toString());
    }

    public static void assertCurrentUrlStartsWithLoginUrlOf(String url) {
        URLAssert.assertCurrentUrlStartsWith(url);
    }

    public static void assertGetURL(URI url, String accessToken, AssertResponseHandler handler) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            HttpGet get = new HttpGet(url);
            get.setHeader("Authorization", "Bearer " + accessToken);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Response status error: " + response.getStatusLine().getStatusCode() + ": " + url);
            }
            handler.assertResponse(response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static abstract class AssertJSONResponseHandler
    implements AssertResponseHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void assertResponse(CloseableHttpResponse response) throws IOException {
            HttpEntity entity = response.getEntity();
            Header contentType = entity.getContentType();
            Assert.assertEquals((Object)"application/json", (Object)contentType.getValue());
            char[] buf = new char[8192];
            StringWriter out = new StringWriter();
            InputStreamReader in = new InputStreamReader(entity.getContent(), Charset.forName("utf-8"));
            try {
                int rc;
                while ((rc = in.read(buf)) != -1) {
                    out.write(buf, 0, rc);
                }
            }
            finally {
                try {
                    ((Reader)in).close();
                }
                catch (Exception exception) {}
                out.close();
            }
            this.assertResponseBody(out.toString());
        }

        protected abstract void assertResponseBody(String var1) throws IOException;
    }

    public static interface AssertResponseHandler {
        public void assertResponse(CloseableHttpResponse var1) throws IOException;
    }
}

