/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.testsuite.util.TextFileChecker;

public class TextFileCheckerTest {
    private TextFileChecker tfc;
    private File tempFile;

    private Consumer<Stream<String>> collector(Collection<String> target) {
        return s -> s.forEachOrdered(target::add);
    }

    @Before
    public void before() throws IOException {
        this.tempFile = File.createTempFile("TextFileCheckerTest-", ".tmp");
        this.tfc = new TextFileChecker(new Path[]{this.tempFile.toPath()});
    }

    @After
    public void after() throws IOException {
        this.tempFile.delete();
    }

    @Test
    public void testFileChecker() throws Exception {
        try (FileWriter fw = new FileWriter(this.tempFile);){
            this.assertCheckedOutputIs(new String[0]);
            fw.write("Hello, Dolly\n");
            fw.flush();
            this.assertCheckedOutputIs("Hello, Dolly");
            fw.write("Well, hello, Dolly\n");
            fw.flush();
            this.assertCheckedOutputIs("Hello, Dolly", "Well, hello, Dolly");
            fw.write("It's so nice to have you back where you belong\n");
            fw.write("You're lookin' swell, Dolly\n");
            fw.flush();
            this.assertCheckedOutputIs("Hello, Dolly", "Well, hello, Dolly", "It's so nice to have you back where you belong", "You're lookin' swell, Dolly");
            this.tfc.updateLastCheckedPositionsOfAllFilesToEndOfFile();
            fw.write("I can tell, Dolly\n");
            fw.write("You're still glowin', you're still crowin'\n");
            fw.flush();
            this.assertCheckedOutputIs("I can tell, Dolly", "You're still glowin', you're still crowin'");
            this.tfc.updateLastCheckedPositionsOfAllFilesToEndOfFile();
            this.assertCheckedOutputIs(new String[0]);
        }
    }

    public void assertCheckedOutputIs(String ... expectedOutput) throws IOException {
        LinkedList<String> target = new LinkedList<String>();
        this.tfc.checkFiles(false, this.collector(target));
        Assert.assertThat(target, (Matcher)(expectedOutput == null || expectedOutput.length == 0 ? Matchers.empty() : Matchers.contains((Object[])expectedOutput)));
    }
}

