/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.util.MailServer;
import org.keycloak.testsuite.util.MessageHandlerFactoryImpl;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.server.SMTPServer;

public class SslMailServer {
    private static final Logger log = Logger.getLogger(MailServer.class);
    public static final String PRIVATE_KEY = "keystore/keycloak.jks";
    public static final String TRUSTED_CERTIFICATE = "keystore/keycloak.truststore";
    public static final String INVALID_KEY = "keystore/email_invalid.jks";
    private static MessageHandlerFactoryImpl messageHandlerFactory = new MessageHandlerFactoryImpl();
    private static SMTPServer smtpServer;
    private static Map<String, String> serverConfiguration;

    public static void start() {
        smtpServer = new SMTPServer((MessageHandlerFactory)messageHandlerFactory);
        smtpServer.setHostName("localhost");
        smtpServer.setPort(Integer.parseInt("3025"));
        smtpServer.start();
        log.info((Object)("Started mail server (" + smtpServer.getHostName() + ":" + smtpServer.getPort() + ")"));
    }

    public static void stop() {
        if (smtpServer != null) {
            log.info((Object)("Stopping mail server (" + smtpServer.getHostName() + ":" + smtpServer.getPort() + ")"));
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (!(e.getCause() instanceof SocketException) || !e.getStackTrace()[0].getClassName().equals("org.subethamail.smtp.server.Session")) {
                        log.error((Object)("Exception in thread \"" + t.getName() + "\" "));
                        log.error((Object)e.getMessage(), e);
                    }
                }
            });
            smtpServer.stop();
        }
    }

    public static void startWithSsl(String privateKey) {
        FileInputStream keyStoreIS = null;
        try {
            keyStoreIS = new FileInputStream(privateKey);
            char[] keyStorePassphrase = "secret".toCharArray();
            KeyStore ksKeys = null;
            ksKeys = KeyStore.getInstance("JKS");
            ksKeys.load(keyStoreIS, keyStorePassphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ksKeys, keyStorePassphrase);
            FileInputStream trustStoreIS = new FileInputStream(String.valueOf(MailServer.class.getClassLoader().getResource(TRUSTED_CERTIFICATE).getFile()));
            char[] trustStorePassphrase = "secret".toCharArray();
            KeyStore ksTrust = KeyStore.getInstance("JKS");
            ksTrust.load(trustStoreIS, trustStorePassphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            tmf.init(ksTrust);
            final SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            smtpServer = new SMTPServer((MessageHandlerFactory)messageHandlerFactory){

                public SSLSocket createSSLSocket(Socket socket) throws IOException {
                    InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
                    SSLSocketFactory sf = sslContext.getSocketFactory();
                    SSLSocket s = (SSLSocket)sf.createSocket(socket, remoteAddress.getHostName(), socket.getPort(), true);
                    s.setUseClientMode(false);
                    s.setEnabledProtocols(s.getSupportedProtocols());
                    s.setEnabledCipherSuites(s.getSupportedCipherSuites());
                    return s;
                }
            };
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
        smtpServer.setHostName("localhost");
        smtpServer.setPort(Integer.parseInt("3465"));
        smtpServer.setEnableTLS(true);
        smtpServer.start();
        log.info((Object)("Started mail server (" + smtpServer.getHostName() + ":" + smtpServer.getPort() + ")"));
    }

    public static Map<String, String> getServerConfiguration() {
        serverConfiguration.put("from", "server@mail.test");
        serverConfiguration.put("host", "localhost");
        serverConfiguration.put("port", "3465");
        serverConfiguration.put("starttls", "true");
        return serverConfiguration;
    }

    public static MimeMessage getLastReceivedMessage() throws InterruptedException {
        return messageHandlerFactory.getMessage();
    }

    static {
        serverConfiguration = new HashMap<String, String>();
    }
}

