/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.undertow.lb.SimpleUndertowLoadBalancer;
import org.keycloak.testsuite.util.ServerURLs;

public class ReverseProxy
implements TestRule {
    public static String DEFAULT_PROXY_HOST = "proxy.kc.127.0.0.1.nip.io";
    public static final int DEFAULT_HTTP_PORT = 8666;
    public static final int DEFAULT_HTTPS_PORT = 8667;
    private final SimpleUndertowLoadBalancer proxy;

    public ReverseProxy() {
        this(DEFAULT_PROXY_HOST);
    }

    public ReverseProxy(String host) {
        this(host, "node1=" + AuthServerTestEnricher.getHttpAuthServerContextRoot() + "/auth");
    }

    public ReverseProxy(String host, String nodes) {
        this.proxy = new SimpleUndertowLoadBalancer(host, 8666, 8667, nodes);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    ReverseProxy.this.proxy.start();
                    ReverseProxy.this.proxy.enableAllBackendNodes();
                    base.evaluate();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                finally {
                    ReverseProxy.this.proxy.stop();
                }
            }
        };
    }

    public String getUrl() {
        String scheme = ServerURLs.AUTH_SERVER_SSL_REQUIRED ? "https" : "http";
        int port = ServerURLs.AUTH_SERVER_SSL_REQUIRED ? 8667 : 8666;
        return ServerURLs.removeDefaultPorts((String)String.format("%s://%s:%s", scheme, DEFAULT_PROXY_HOST, port));
    }
}

