/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.keycloak.admin.client.resource.ComponentResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.PemUtils;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;

public class RealmManager {
    private static RealmResource realm;

    private RealmManager() {
    }

    public static RealmManager realm(RealmResource realm) {
        RealmManager.realm = realm;
        return new RealmManager();
    }

    public RealmManager accessCodeLifeSpan(Integer accessCodeLifespan) {
        RealmRepresentation realmRepresentation = realm.toRepresentation();
        realmRepresentation.setAccessCodeLifespan(accessCodeLifespan);
        realm.update(realmRepresentation);
        return this;
    }

    public RealmManager verifyEmail(Boolean enabled) {
        RealmRepresentation rep = realm.toRepresentation();
        rep.setVerifyEmail(enabled);
        realm.update(rep);
        return this;
    }

    public RealmManager passwordPolicy(String passwordPolicy) {
        RealmRepresentation rep = realm.toRepresentation();
        rep.setPasswordPolicy(passwordPolicy);
        realm.update(rep);
        return this;
    }

    public RealmManager revokeRefreshToken(boolean enable) {
        RealmRepresentation rep = realm.toRepresentation();
        rep.setRevokeRefreshToken(Boolean.valueOf(enable));
        realm.update(rep);
        return this;
    }

    public RealmManager refreshTokenMaxReuse(int refreshTokenMaxReuse) {
        RealmRepresentation rep = realm.toRepresentation();
        rep.setRefreshTokenMaxReuse(Integer.valueOf(refreshTokenMaxReuse));
        realm.update(rep);
        return this;
    }

    public void generateKeys() {
        KeyPair keyPair;
        RealmRepresentation rep = realm.toRepresentation();
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048);
            keyPair = generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        rep.setPrivateKey(Base64.encodeBytes((byte[])keyPair.getPrivate().getEncoded()));
        rep.setPublicKey(Base64.encodeBytes((byte[])keyPair.getPublic().getEncoded()));
        try {
            X509Certificate certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)rep.getId());
            rep.setCertificate(Base64.encodeBytes((byte[])certificate.getEncoded()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        rep.setCodeSecret(KeycloakModelUtils.generateCodeSecret());
        realm.update(rep);
    }

    public void keyPair(String privateKey, String publicKey) {
        RealmRepresentation rep = realm.toRepresentation();
        rep.setPrivateKey(privateKey);
        rep.setPublicKey(publicKey);
        realm.update(rep);
    }

    public String generateNewRsaKey(KeyPair keyPair, String name) {
        RealmRepresentation rep = realm.toRepresentation();
        X509Certificate certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)"test");
        String certificatePem = PemUtils.encodeCertificate((Certificate)certificate);
        ComponentRepresentation keyProviderRepresentation = new ComponentRepresentation();
        keyProviderRepresentation.setName(name);
        keyProviderRepresentation.setParentId(rep.getId());
        keyProviderRepresentation.setProviderId("rsa");
        keyProviderRepresentation.setProviderType(KeyProvider.class.getName());
        MultivaluedHashMap config = new MultivaluedHashMap();
        config.putSingle((Object)"privateKey", (Object)PemUtils.encodeKey((Key)keyPair.getPrivate()));
        config.putSingle((Object)"certificate", (Object)certificatePem);
        config.putSingle((Object)"priority", (Object)"100");
        keyProviderRepresentation.setConfig(config);
        Response response = realm.components().add(keyProviderRepresentation);
        String providerId = ApiUtil.getCreatedId((Response)response);
        response.close();
        this.deactivateOtherRsaKeys(providerId);
        return providerId;
    }

    private void deactivateOtherRsaKeys(String providerId) {
        List otherRsaKeyProviderIds = realm.keys().getKeyMetadata().getKeys().stream().filter(key -> "RSA".equals(key.getType()) && !providerId.equals(key.getProviderId())).map(key -> key.getProviderId()).collect(Collectors.toList());
        for (String otherRsaKeyProviderId : otherRsaKeyProviderIds) {
            ComponentResource componentResource = realm.components().component(otherRsaKeyProviderId);
            ComponentRepresentation componentRepresentation = componentResource.toRepresentation();
            componentRepresentation.getConfig().putSingle((Object)"active", (Object)"false");
            componentResource.update(componentRepresentation);
        }
    }

    public void ssoSessionMaxLifespan(int ssoSessionMaxLifespan) {
        RealmRepresentation rep = realm.toRepresentation();
        rep.setSsoSessionMaxLifespan(Integer.valueOf(ssoSessionMaxLifespan));
        realm.update(rep);
    }

    public void sslRequired(String sslRequired) {
        RealmRepresentation rep = realm.toRepresentation();
        rep.setSslRequired(sslRequired);
        realm.update(rep);
    }

    public void accessTokenLifespan(int accessTokenLifespan) {
        RealmRepresentation rep = realm.toRepresentation();
        rep.setAccessTokenLifespan(Integer.valueOf(accessTokenLifespan));
        realm.update(rep);
    }

    public RealmManager ssoSessionIdleTimeout(int ssoSessionIdleTimeout) {
        RealmRepresentation rep = realm.toRepresentation();
        rep.setSsoSessionIdleTimeout(Integer.valueOf(ssoSessionIdleTimeout));
        realm.update(rep);
        return this;
    }
}

