/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.oidc.mappers.AddressMapper;
import org.keycloak.protocol.oidc.mappers.AudienceProtocolMapper;
import org.keycloak.protocol.oidc.mappers.HardcodedClaim;
import org.keycloak.protocol.oidc.mappers.HardcodedRole;
import org.keycloak.protocol.oidc.mappers.RoleNameMapper;
import org.keycloak.protocol.oidc.mappers.SHA256PairwiseSubMapper;
import org.keycloak.protocol.oidc.mappers.ScriptBasedOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.UserAttributeMapper;
import org.keycloak.protocol.oidc.mappers.UserClientRoleMappingMapper;
import org.keycloak.protocol.oidc.mappers.UserRealmRoleMappingMapper;
import org.keycloak.protocol.oidc.mappers.UserSessionNoteMapper;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;

public class ProtocolMapperUtil {
    public static ProtocolMapperRepresentation createRoleNameMapper(String name, String role, String newName) {
        return ModelToRepresentation.toRepresentation((ProtocolMapperModel)RoleNameMapper.create((String)name, (String)role, (String)newName));
    }

    public static ProtocolMapperRepresentation createHardcodedRole(String name, String role) {
        return ModelToRepresentation.toRepresentation((ProtocolMapperModel)HardcodedRole.create((String)name, (String)role));
    }

    public static ProtocolMapperRepresentation createAddressMapper(boolean idToken, boolean accessToken, boolean userInfo) {
        return ModelToRepresentation.toRepresentation((ProtocolMapperModel)AddressMapper.createAddressMapper((boolean)idToken, (boolean)accessToken, (boolean)userInfo));
    }

    public static ProtocolMapperRepresentation createHardcodedClaim(String name, String hardcodedName, String hardcodedValue, String claimType, boolean accessToken, boolean idToken) {
        return ModelToRepresentation.toRepresentation((ProtocolMapperModel)HardcodedClaim.create((String)name, (String)hardcodedName, (String)hardcodedValue, (String)claimType, (boolean)accessToken, (boolean)idToken));
    }

    public static ProtocolMapperRepresentation createClaimMapper(String name, String userAttribute, String tokenClaimName, String claimType, boolean accessToken, boolean idToken, boolean multivalued) {
        return ModelToRepresentation.toRepresentation((ProtocolMapperModel)UserAttributeMapper.createClaimMapper((String)name, (String)userAttribute, (String)tokenClaimName, (String)claimType, (boolean)accessToken, (boolean)idToken, (boolean)multivalued, (boolean)false));
    }

    public static ProtocolMapperRepresentation createClaimMapper(String name, String userAttribute, String tokenClaimName, String claimType, boolean accessToken, boolean idToken, boolean multivalued, boolean aggregateAttrs) {
        return ModelToRepresentation.toRepresentation((ProtocolMapperModel)UserAttributeMapper.createClaimMapper((String)name, (String)userAttribute, (String)tokenClaimName, (String)claimType, (boolean)accessToken, (boolean)idToken, (boolean)multivalued, (boolean)aggregateAttrs));
    }

    public static ProtocolMapperRepresentation createClaimMapper(String name, String userSessionNote, String tokenClaimName, String jsonType, boolean accessToken, boolean idToken) {
        return ModelToRepresentation.toRepresentation((ProtocolMapperModel)UserSessionNoteMapper.createClaimMapper((String)name, (String)userSessionNote, (String)tokenClaimName, (String)jsonType, (boolean)accessToken, (boolean)idToken));
    }

    public static ProtocolMapperRepresentation createUserRealmRoleMappingMapper(String realmRolePrefix, String name, String tokenClaimName, boolean accessToken, boolean idToken) {
        return ProtocolMapperUtil.createUserRealmRoleMappingMapper(realmRolePrefix, name, tokenClaimName, accessToken, idToken, false);
    }

    public static ProtocolMapperRepresentation createUserRealmRoleMappingMapper(String realmRolePrefix, String name, String tokenClaimName, boolean accessToken, boolean idToken, boolean multiValued) {
        return ModelToRepresentation.toRepresentation((ProtocolMapperModel)UserRealmRoleMappingMapper.create((String)realmRolePrefix, (String)name, (String)tokenClaimName, (boolean)accessToken, (boolean)idToken, (boolean)multiValued));
    }

    public static ProtocolMapperRepresentation createUserClientRoleMappingMapper(String clientId, String clientRolePrefix, String name, String tokenClaimName, boolean accessToken, boolean idToken) {
        return ProtocolMapperUtil.createUserClientRoleMappingMapper(clientId, clientRolePrefix, name, tokenClaimName, accessToken, idToken, false);
    }

    public static ProtocolMapperRepresentation createUserClientRoleMappingMapper(String clientId, String clientRolePrefix, String name, String tokenClaimName, boolean accessToken, boolean idToken, boolean multiValued) {
        return ModelToRepresentation.toRepresentation((ProtocolMapperModel)UserClientRoleMappingMapper.create((String)clientId, (String)clientRolePrefix, (String)name, (String)tokenClaimName, (boolean)accessToken, (boolean)idToken, (boolean)multiValued));
    }

    public static ProtocolMapperRepresentation getMapperByNameAndProtocol(ProtocolMappersResource protocolMappers, String protocol, String name) {
        for (ProtocolMapperRepresentation mapper : protocolMappers.getMappersPerProtocol(protocol)) {
            if (!name.equals(mapper.getName())) continue;
            return mapper;
        }
        return null;
    }

    public static ProtocolMapperRepresentation createScriptMapper(String name, String userAttribute, String tokenClaimName, String claimType, boolean accessToken, boolean idToken, String script, boolean multiValued) {
        return ModelToRepresentation.toRepresentation((ProtocolMapperModel)ScriptBasedOIDCProtocolMapper.create((String)name, (String)userAttribute, (String)tokenClaimName, (String)claimType, (boolean)accessToken, (boolean)idToken, (String)script, (boolean)multiValued));
    }

    public static ProtocolMapperRepresentation createPairwiseMapper(String sectorIdentifierUri, String salt) {
        return SHA256PairwiseSubMapper.createPairwiseMapper((String)sectorIdentifierUri, (String)salt);
    }

    public static ProtocolMapperRepresentation createAudienceMapper(String name, String includedClientAudience, String includedCustomAudience, boolean accessToken, boolean idToken) {
        return ModelToRepresentation.toRepresentation((ProtocolMapperModel)AudienceProtocolMapper.createClaimMapper((String)name, (String)includedClientAudience, (String)includedCustomAudience, (boolean)accessToken, (boolean)idToken));
    }
}

