/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

public class NonIDERunListener
extends RunListener {
    private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(NonIDERunListener.class);
    private static final String KEYCLOAK_LOGGING_LEVEL_NAME = "keycloak.logging.level";

    public void testRunStarted(Description description) throws Exception {
        this.disableKeycloakLogging();
    }

    private void disableKeycloakLogging() {
        String loggingLevel = System.getProperty(KEYCLOAK_LOGGING_LEVEL_NAME, "").toLowerCase();
        if (loggingLevel.isEmpty()) {
            log.infof("Setting %s to off. Keycloak server logging will be disabled", (Object)KEYCLOAK_LOGGING_LEVEL_NAME);
            System.setProperty(KEYCLOAK_LOGGING_LEVEL_NAME, "off");
            Logger.getLogger((String)"org.keycloak").setLevel(Level.OFF);
        } else {
            switch (loggingLevel) {
                case "debug": {
                    Logger.getLogger((String)"org.keycloak").setLevel(Level.DEBUG);
                    break;
                }
                case "trace": {
                    Logger.getLogger((String)"org.keycloak").setLevel(Level.TRACE);
                    break;
                }
                case "all": {
                    Logger.getLogger((String)"org.keycloak").setLevel(Level.ALL);
                    break;
                }
                default: {
                    Logger.getLogger((String)"org.keycloak").setLevel(Level.INFO);
                }
            }
        }
    }
}

